/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.terracotta.passthrough.Assert;

public abstract class PassthroughMessage {
    public final Type type;
    public final boolean shouldReplicateToPassives;
    public long transactionID;
    public long oldestTransactionID;

    public static Type getType(DataInputStream input) throws IOException {
        int ordinal = input.readInt();
        return Type.values()[ordinal];
    }

    public PassthroughMessage(Type type, boolean shouldReplicateToPassives) {
        this.shouldReplicateToPassives = shouldReplicateToPassives;
        this.type = type;
    }

    public void setTransactionTracking(long transactionID, long oldestTransactionID) {
        this.transactionID = transactionID;
        this.oldestTransactionID = oldestTransactionID;
    }

    public byte[] asSerializedBytes() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(bytes);
            output.writeInt(this.type.ordinal());
            output.writeBoolean(this.shouldReplicateToPassives);
            output.writeLong(this.transactionID);
            output.writeLong(this.oldestTransactionID);
            this.populateStream(output);
            output.close();
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
        return bytes.toByteArray();
    }

    protected abstract void populateStream(DataOutputStream var1) throws IOException;

    public static enum Type {
        FETCH_ENTITY,
        RELEASE_ENTITY,
        DOES_ENTITY_EXIST,
        CREATE_ENTITY,
        RECONFIGURE_ENTITY,
        DESTROY_ENTITY,
        INVOKE_ON_SERVER,
        ACK_FROM_SERVER,
        COMPLETE_FROM_SERVER,
        EXCEPTION_FROM_SERVER,
        RETIRE_FROM_SERVER,
        INVOKE_ON_CLIENT,
        RECONNECT,
        SYNC_ENTITY_START,
        SYNC_ENTITY_END,
        SYNC_ENTITY_KEY_START,
        SYNC_ENTITY_KEY_END,
        SYNC_ENTITY_PAYLOAD,
        UNEXPECTED_RELEASE,
        DROP_LOCK,
        MONITOR_MESSAGE,
        MONITOR_EXCEPTION;

    }
}

