/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.terracotta.exception.EntityException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughServerMessageDecoder;
import org.terracotta.persistence.IPlatformPersistence;

public class PassthroughLifeCycleHandler
implements PassthroughServerMessageDecoder.LifeCycleMessageHandler {
    private static final String LIFE_CYCLE_RECORD_FILE_NAME = "life_cycle_record.map";
    private final IPlatformPersistence platformPersistence;
    private final HashMap<Long, List<LifeCycleRecord>> lifeCycleRecordByClientIDMap;

    public PassthroughLifeCycleHandler(IPlatformPersistence platformPersistence, boolean shouldLoadStorage) {
        Assert.assertTrue(null != platformPersistence);
        this.platformPersistence = platformPersistence;
        HashMap loadedMap = null;
        try {
            loadedMap = (HashMap)(shouldLoadStorage ? this.platformPersistence.loadDataElement(LIFE_CYCLE_RECORD_FILE_NAME) : null);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
        if (null == loadedMap) {
            loadedMap = new HashMap();
        }
        this.lifeCycleRecordByClientIDMap = loadedMap;
    }

    @Override
    public boolean didAlreadyHandle(long clientOriginID, long transactionID) throws EntityException {
        boolean didHandle = false;
        List<LifeCycleRecord> records = this.loadClient(clientOriginID);
        if (null != records) {
            for (LifeCycleRecord record : records) {
                if (record.transactionID != transactionID) continue;
                if (null == record.error) {
                    didHandle = true;
                    break;
                }
                throw record.error;
            }
        }
        return didHandle;
    }

    @Override
    public byte[] didAlreadyHandleResult(long clientOriginID, long transactionID) throws EntityException {
        byte[] result = null;
        List<LifeCycleRecord> records = this.loadClient(clientOriginID);
        if (null != records) {
            for (LifeCycleRecord record : records) {
                if (record.transactionID != transactionID) continue;
                if (null == record.error) {
                    Assert.assertTrue(null != record.reconfigureResult);
                    result = record.reconfigureResult;
                    break;
                }
                throw record.error;
            }
        }
        return result;
    }

    @Override
    public void failureInMessage(long clientOriginID, long transactionID, long oldestTransactionID, EntityException error) {
        this.addNewRecord(clientOriginID, transactionID, oldestTransactionID, null, error);
    }

    @Override
    public void successInMessage(long clientOriginID, long transactionID, long oldestTransactionID, byte[] reconfigureResponse) {
        EntityException error = null;
        this.addNewRecord(clientOriginID, transactionID, oldestTransactionID, reconfigureResponse, error);
    }

    private void addNewRecord(long clientOriginID, long transactionID, long oldestTransactionID, byte[] reconfigureResult, EntityException error) {
        List<LifeCycleRecord> newRecords = this.filteredRecords(clientOriginID, oldestTransactionID);
        LifeCycleRecord newRecord = new LifeCycleRecord();
        newRecord.transactionID = transactionID;
        newRecord.reconfigureResult = reconfigureResult;
        newRecord.error = error;
        newRecords.add(newRecord);
        this.storeClient(clientOriginID, newRecords);
    }

    private List<LifeCycleRecord> filteredRecords(long clientOriginID, long oldestTransactionID) {
        List<LifeCycleRecord> records = this.loadClient(clientOriginID);
        if (null == records) {
            records = new Vector<LifeCycleRecord>();
        }
        Vector<LifeCycleRecord> newRecords = new Vector<LifeCycleRecord>();
        for (LifeCycleRecord record : records) {
            if (record.transactionID < oldestTransactionID) continue;
            newRecords.add(record);
        }
        return newRecords;
    }

    private List<LifeCycleRecord> loadClient(long clientOriginID) {
        return this.lifeCycleRecordByClientIDMap.get(clientOriginID);
    }

    private void storeClient(long clientOriginID, List<LifeCycleRecord> data) {
        this.lifeCycleRecordByClientIDMap.put(clientOriginID, data);
        try {
            this.platformPersistence.storeDataElement(LIFE_CYCLE_RECORD_FILE_NAME, this.lifeCycleRecordByClientIDMap);
        }
        catch (IOException e) {
            Assert.unexpected(e);
        }
    }

    private static class LifeCycleRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public long transactionID;
        public byte[] reconfigureResult;
        public EntityException error;

        private LifeCycleRecord() {
        }
    }
}

