/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughMonitor;

public class PassthroughInvocationBuilder<M extends EntityMessage, R extends EntityResponse>
implements InvocationBuilder<M, R> {
    private final PassthroughConnection connection;
    private final String entityClassName;
    private final String entityName;
    private final long clientInstanceID;
    private final MessageCodec<M, R> messageCodec;
    private boolean shouldWaitForSent;
    private boolean shouldWaitForReceived;
    private boolean shouldWaitForCompleted;
    private boolean shouldWaitForRetired;
    private boolean shouldReplicate;
    private boolean shouldBlockGetUntilRetire;
    private M request;
    private InvokeMonitor monitor;
    private Executor executor;

    public PassthroughInvocationBuilder(PassthroughConnection connection, String entityClassName, String entityName, long clientInstanceID, MessageCodec<M, R> messageCodec) {
        this.connection = connection;
        this.entityClassName = entityClassName;
        this.entityName = entityName;
        this.clientInstanceID = clientInstanceID;
        this.messageCodec = messageCodec;
        this.shouldReplicate = true;
        this.shouldBlockGetUntilRetire = true;
    }

    public InvocationBuilder<M, R> ackSent() {
        this.shouldWaitForSent = true;
        return this;
    }

    public InvocationBuilder<M, R> ackReceived() {
        this.shouldWaitForReceived = true;
        return this;
    }

    public InvocationBuilder<M, R> ackCompleted() {
        this.shouldWaitForCompleted = true;
        return this;
    }

    public InvocationBuilder<M, R> ackRetired() {
        this.shouldWaitForRetired = true;
        return this;
    }

    public InvocationBuilder<M, R> replicate(boolean requiresReplication) {
        this.shouldReplicate = requiresReplication;
        return this;
    }

    public InvocationBuilder<M, R> message(M message) {
        this.request = message;
        return this;
    }

    public InvocationBuilder<M, R> monitor(InvokeMonitor<R> consumer) {
        this.monitor = consumer;
        return this;
    }

    public InvocationBuilder<M, R> withExecutor(Executor exctr) {
        this.executor = exctr;
        return this;
    }

    @Deprecated
    public InvocationBuilder<M, R> asDeferredResponse() {
        this.shouldBlockGetUntilRetire = true;
        return this;
    }

    public InvocationBuilder<M, R> blockGetOnRetire(boolean shouldBlock) {
        this.shouldBlockGetUntilRetire = shouldBlock;
        return this;
    }

    public InvokeFuture<R> invokeWithTimeout(long time, TimeUnit units) throws InterruptedException, TimeoutException, MessageCodecException {
        return this.invoke();
    }

    public InvokeFuture<R> invoke() throws MessageCodecException {
        PassthroughMessage message = PassthroughMessageCodec.createInvokeMessage(this.entityClassName, this.entityName, this.clientInstanceID, this.messageCodec.encodeMessage(this.request), this.shouldReplicate);
        final Future<byte[]> invokeFuture = this.connection.invokeActionAndWaitForAcks(message, this.shouldWaitForSent, this.shouldWaitForReceived, this.shouldWaitForCompleted, this.shouldWaitForRetired, this.shouldBlockGetUntilRetire, new PassthroughMonitor<R>(this.messageCodec, this.monitor, this.executor));
        return new InvokeFuture<R>(){

            public boolean isDone() {
                return invokeFuture.isDone();
            }

            public R get() throws InterruptedException, EntityException {
                try {
                    return PassthroughInvocationBuilder.this.messageCodec.decodeResponse((byte[])invokeFuture.get());
                }
                catch (MessageCodecException e) {
                    throw new EntityServerException(null, null, null, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw (EntityException)e.getCause();
                }
            }

            public R getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
                try {
                    return PassthroughInvocationBuilder.this.messageCodec.decodeResponse((byte[])invokeFuture.get(timeout, unit));
                }
                catch (MessageCodecException e) {
                    throw new EntityServerException(null, null, null, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw (EntityException)e.getCause();
                }
            }

            public void interrupt() {
                invokeFuture.cancel(true);
            }
        };
    }
}

