/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.IMessageSenderWrapper;
import org.terracotta.passthrough.PassthroughClientDescriptor;
import org.terracotta.passthrough.PassthroughMessage;

public class PassthroughInterserverInterlock
implements IMessageSenderWrapper {
    private final IMessageSenderWrapper sender;
    private boolean isComplete = false;
    private boolean didSucceed = false;
    private boolean isRetired = false;

    public PassthroughInterserverInterlock(IMessageSenderWrapper sender) {
        this.sender = sender;
    }

    public synchronized boolean waitForComplete() {
        while (!this.isComplete) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.unexpected(e);
            }
        }
        return this.didSucceed;
    }

    public synchronized boolean waitForRetired() {
        while (!this.isRetired) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.unexpected(e);
            }
        }
        return this.didSucceed;
    }

    @Override
    public void sendAck(PassthroughMessage ack) {
    }

    @Override
    public synchronized void sendComplete(PassthroughMessage complete, boolean last) {
        this.isComplete = last;
        this.didSucceed = complete.type != PassthroughMessage.Type.MONITOR_EXCEPTION;
        this.notifyAll();
    }

    @Override
    public synchronized void sendRetire(PassthroughMessage retire) {
        this.isRetired = true;
        this.notifyAll();
    }

    @Override
    public PassthroughClientDescriptor clientDescriptorForID(long clientInstanceID) {
        return new PassthroughClientDescriptor(null, null, clientInstanceID);
    }

    @Override
    public long getClientOriginID() {
        long origin = -1L;
        if (null != this.sender) {
            origin = this.sender.getClientOriginID();
        }
        return origin;
    }
}

