/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.concurrent.ExecutionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughWait;

public class PassthroughEntityRef<T extends Entity, C, U>
implements EntityRef<T, C, U> {
    private final PassthroughConnection passthroughConnection;
    private final EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse, U> service;
    private final String clazz;
    private final long version;
    private final String name;

    public PassthroughEntityRef(PassthroughConnection passthroughConnection, EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse, U> service, String clazz, long version, String name) {
        this.passthroughConnection = passthroughConnection;
        this.service = service;
        this.clazz = clazz;
        this.version = version;
        this.name = name;
    }

    public boolean isValid() {
        return this.passthroughConnection.isValid();
    }

    public T fetchEntity(U userData) throws EntityNotFoundException, EntityVersionMismatchException {
        long clientInstanceID = this.passthroughConnection.getNewInstanceID();
        PassthroughMessage getMessage = PassthroughMessageCodec.createFetchMessage(this.clazz, this.name, clientInstanceID, this.version);
        PassthroughWait received = this.passthroughConnection.sendInternalMessageAfterAcks(getMessage);
        received.blockGetOnRetire();
        byte[] rawConfig = null;
        try {
            rawConfig = received.get();
        }
        catch (ExecutionException b) {
            EntityException e = (EntityException)b.getCause();
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            Assert.unexpected(e);
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
        try {
            Class<?> type = Class.forName(this.clazz);
            return (T)((Entity)this.passthroughConnection.createEntityInstance(type, this.name, clientInstanceID, this.version, rawConfig, userData));
        }
        catch (ClassNotFoundException notfound) {
            throw new EntityNotFoundException(this.clazz, this.name, (Throwable)notfound);
        }
    }

    public String getName() {
        return this.name;
    }

    public void create(C configuration) throws EntityNotProvidedException, EntityAlreadyExistsException, EntityVersionMismatchException, EntityConfigurationException {
        if (null != this.service) {
            byte[] serializedConfiguration = this.service.serializeConfiguration(configuration);
            PassthroughMessage getMessage = PassthroughMessageCodec.createCreateMessage(this.clazz, this.name, this.version, serializedConfiguration);
            PassthroughWait received = this.passthroughConnection.sendInternalMessageAfterAcks(getMessage);
            received.blockGetOnRetire();
            try {
                received.get();
            }
            catch (ExecutionException b) {
                EntityException e = (EntityException)b.getCause();
                if (e instanceof EntityNotProvidedException) {
                    throw (EntityNotProvidedException)e;
                }
                if (e instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)e;
                }
                if (e instanceof EntityVersionMismatchException) {
                    throw (EntityVersionMismatchException)e;
                }
                if (e instanceof EntityConfigurationException) {
                    throw (EntityConfigurationException)e;
                }
                Assert.unexpected(e);
            }
            catch (InterruptedException e) {
                Assert.unexpected(e);
            }
        } else {
            throw new EntityNotProvidedException(this.clazz, this.name);
        }
    }

    public C reconfigure(C configuration) throws EntityNotProvidedException, EntityNotFoundException, EntityConfigurationException {
        Object result = null;
        if (null != this.service) {
            byte[] serializedConfiguration = this.service.serializeConfiguration(configuration);
            PassthroughMessage reconfig = PassthroughMessageCodec.createReconfigureMessage(this.clazz, this.name, this.version, serializedConfiguration);
            PassthroughWait received = this.passthroughConnection.sendInternalMessageAfterAcks(reconfig);
            received.blockGetOnRetire();
            try {
                result = this.service.deserializeConfiguration(received.get());
            }
            catch (ExecutionException b) {
                EntityException e = (EntityException)b.getCause();
                if (e instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)e;
                }
                if (e instanceof EntityNotProvidedException) {
                    throw (EntityNotProvidedException)e;
                }
                if (e instanceof EntityConfigurationException) {
                    throw (EntityConfigurationException)e;
                }
                Assert.unexpected(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new EntityNotProvidedException(this.clazz, this.name);
        }
        return (C)result;
    }

    public boolean destroy() throws EntityNotProvidedException, EntityNotFoundException {
        return this.destroyEntity();
    }

    private boolean destroyEntity() throws EntityNotProvidedException, EntityNotFoundException {
        PassthroughMessage getMessage = PassthroughMessageCodec.createDestroyMessage(this.clazz, this.name);
        PassthroughWait received = this.passthroughConnection.sendInternalMessageAfterAcks(getMessage);
        received.blockGetOnRetire();
        try {
            return received.get()[0] != 0;
        }
        catch (ExecutionException b) {
            EntityException e = (EntityException)b.getCause();
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            Assert.unexpected(e);
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
        return false;
    }
}

