/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughInvocationBuilder;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughWait;

public class PassthroughEntityClientEndpoint<M extends EntityMessage, R extends EntityResponse>
implements EntityClientEndpoint<M, R> {
    private final PassthroughConnection connection;
    private final Class<?> entityClass;
    private final String entityName;
    private final long clientInstanceID;
    private final byte[] config;
    private final MessageCodec<M, R> messageCodec;
    private final Runnable onClose;
    private EndpointDelegate delegate;
    private boolean isOpen;

    public PassthroughEntityClientEndpoint(PassthroughConnection passthroughConnection, Class<?> entityClass, String entityName, long clientInstanceID, byte[] config, MessageCodec<M, R> messageCodec, Runnable onClose) {
        this.connection = passthroughConnection;
        this.entityClass = entityClass;
        this.entityName = entityName;
        this.clientInstanceID = clientInstanceID;
        this.config = config;
        this.messageCodec = messageCodec;
        this.onClose = onClose;
        this.isOpen = true;
    }

    public byte[] getEntityConfiguration() {
        this.checkEndpointOpen();
        return this.config;
    }

    public void setDelegate(EndpointDelegate delegate) {
        this.checkEndpointOpen();
        Assert.assertTrue(null == this.delegate);
        this.delegate = delegate;
    }

    public InvocationBuilder<M, R> beginInvoke() {
        this.checkEndpointOpen();
        return new PassthroughInvocationBuilder<M, R>(this.connection, this.entityClass.getCanonicalName(), this.entityName, this.clientInstanceID, this.messageCodec);
    }

    public void close() {
        this.checkEndpointOpen();
        this.isOpen = false;
        PassthroughMessage releaseMessage = PassthroughMessageCodec.createReleaseMessage(this.entityClass.getCanonicalName(), this.entityName, this.clientInstanceID);
        PassthroughWait received = this.connection.sendInternalMessageAfterAcks(releaseMessage);
        try {
            received.get();
        }
        catch (InterruptedException e) {
            Assert.unexpected(e);
        }
        catch (ExecutionException e) {
            Assert.unexpected(e);
        }
        this.onClose.run();
    }

    public Future<Void> release() {
        this.close();
        return CompletableFuture.completedFuture(null);
    }

    public void didCloseUnexpectedly() {
        if (null != this.delegate) {
            this.delegate.didDisconnectUnexpectedly();
        }
    }

    public void handleMessageFromServer(byte[] payload) throws MessageCodecException {
        if (null != this.delegate) {
            EntityResponse fromServer = this.messageCodec.decodeResponse(payload);
            this.delegate.handleMessage(fromServer);
        }
    }

    public byte[] getExtendedReconnectData() {
        byte[] toReturn = null;
        if (null != this.delegate) {
            toReturn = this.delegate.createExtendedReconnectData();
        }
        if (null == toReturn) {
            toReturn = new byte[]{};
        }
        return toReturn;
    }

    public PassthroughMessage buildReconnectMessage(byte[] extendedData) {
        return PassthroughMessageCodec.createReconnectMessage(this.entityClass.getCanonicalName(), this.entityName, this.clientInstanceID, extendedData);
    }

    public PassthroughMessage createUnexpectedReleaseMessage() {
        return PassthroughMessageCodec.createUnexpectedReleaseMessage(this.entityClass.getCanonicalName(), this.entityName, this.clientInstanceID);
    }

    private void checkEndpointOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Endpoint closed");
        }
    }
}

