/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.HashMap;
import java.util.Map;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMonitor;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughWait;

public class PassthroughConnectionState {
    private PassthroughServerProcess serverProcess;
    private final Map<Long, PassthroughWait> inFlightMessages;
    private PassthroughServerProcess reconnectingServerProcess;
    private long nextTransactionID;

    public PassthroughConnectionState(PassthroughServerProcess initialServerProcess) {
        this.serverProcess = initialServerProcess;
        this.inFlightMessages = new HashMap<Long, PassthroughWait>();
        this.nextTransactionID = 1L;
    }

    public boolean isServerThread() {
        return this.serverProcess.isServerThread();
    }

    public synchronized PassthroughWait sendNormal(PassthroughConnection sender, PassthroughMessage message, boolean shouldWaitForSent, boolean shouldWaitForReceived, boolean shouldWaitForCompleted, boolean shouldWaitForRetired, boolean forceGetToBlockOnRetire, PassthroughMonitor monitor) {
        while (null == this.serverProcess) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        long oldestTransactionID = this.nextTransactionID;
        for (long oneID : this.inFlightMessages.keySet()) {
            if (oneID >= oldestTransactionID) continue;
            oldestTransactionID = oneID;
        }
        return this.createAndSend(this.serverProcess, this.inFlightMessages, sender, message, oldestTransactionID, shouldWaitForSent, shouldWaitForReceived, shouldWaitForCompleted, shouldWaitForRetired, forceGetToBlockOnRetire, monitor);
    }

    private PassthroughWait createAndSend(PassthroughServerProcess target, Map<Long, PassthroughWait> tracker, PassthroughConnection sender, PassthroughMessage message, long oldestTransactionID, boolean shouldWaitForSent, boolean shouldWaitForReceived, boolean shouldWaitForCompleted, boolean shouldWaitForRetired, boolean forceGetToBlockOnRetire, PassthroughMonitor monitor) {
        PassthroughWait waiter = new PassthroughWait(shouldWaitForSent, shouldWaitForReceived, shouldWaitForCompleted, shouldWaitForRetired, forceGetToBlockOnRetire, monitor);
        long transactionID = this.nextTransactionID++;
        message.setTransactionTracking(transactionID, oldestTransactionID);
        tracker.put(transactionID, waiter);
        if (shouldWaitForSent) {
            waiter.sent();
        }
        byte[] raw = message.asSerializedBytes();
        waiter.saveRawMessageForResend(raw);
        target.sendMessageToServer(sender, raw);
        return waiter;
    }

    public synchronized boolean isConnected(PassthroughServerProcess sender) {
        return sender == this.serverProcess || sender == this.reconnectingServerProcess;
    }

    public synchronized PassthroughWait sendAsReconnect(PassthroughConnection sender, PassthroughMessage message, boolean shouldWaitForSent, boolean shouldWaitForReceived, boolean shouldWaitForCompleted, boolean shouldWaitForRetired, boolean forceGetToBlockOnRetire) {
        Assert.assertTrue(null != this.reconnectingServerProcess);
        long oldestTransactionID = 0L;
        return this.createAndSend(this.reconnectingServerProcess, this.inFlightMessages, sender, message, oldestTransactionID, shouldWaitForSent, shouldWaitForReceived, shouldWaitForCompleted, shouldWaitForRetired, forceGetToBlockOnRetire, null);
    }

    public synchronized Map<Long, PassthroughWait> enterReconnectState(PassthroughServerProcess newServerProcess) {
        Assert.assertTrue(null == this.serverProcess);
        Assert.assertTrue(null == this.reconnectingServerProcess);
        Assert.assertTrue(null != this.inFlightMessages);
        this.reconnectingServerProcess = newServerProcess;
        return this.inFlightMessages;
    }

    public synchronized void sendAsResend(PassthroughConnection sender, long transactionID, PassthroughWait waiter) {
        Assert.assertTrue(null != this.reconnectingServerProcess);
        byte[] raw = waiter.resetAndGetMessageForResend();
        this.inFlightMessages.put(transactionID, waiter);
        waiter.blockGetOnRetire();
        this.reconnectingServerProcess.sendMessageToServer(sender, raw);
    }

    public synchronized PassthroughWait getWaiterForTransaction(PassthroughServerProcess sender, long transactionID) {
        PassthroughWait waiter = this.inFlightMessages.get(transactionID);
        Assert.assertTrue(null != waiter);
        return waiter;
    }

    public synchronized PassthroughWait removeWaiterForTransaction(PassthroughServerProcess sender, long transactionID) {
        PassthroughWait waiter = this.inFlightMessages.remove(transactionID);
        Assert.assertTrue(null != waiter);
        return waiter;
    }

    public synchronized void finishReconnectState() {
        Assert.assertTrue(null == this.serverProcess);
        Assert.assertTrue(null != this.reconnectingServerProcess);
        this.serverProcess = this.reconnectingServerProcess;
        this.reconnectingServerProcess = null;
        this.notifyAll();
    }

    public synchronized void enterDisconnectedState() {
        Assert.assertTrue(null != this.serverProcess);
        Assert.assertTrue(null != this.inFlightMessages);
        this.serverProcess = null;
    }

    public synchronized void forceClose() {
        Assert.assertTrue(null != this.inFlightMessages);
        for (PassthroughWait waiter : this.inFlightMessages.values()) {
            waiter.forceDisconnect();
        }
    }
}

