/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.net.InetSocketAddress;
import java.net.URI;
import java.rmi.UnknownHostException;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughServer;
import org.terracotta.passthrough.PassthroughServerRegistry;

public class PassthroughConnectionService
implements ConnectionService {
    private static final String CONNECTION_TYPE = "passthrough";

    public boolean handlesURI(URI uri) {
        return this.handlesConnectionType(uri.getScheme());
    }

    public boolean handlesConnectionType(String connectionType) {
        return CONNECTION_TYPE.equals(connectionType);
    }

    public Connection connect(URI uri, Properties properties) throws ConnectionException {
        return this.getConnection(uri.getHost(), properties);
    }

    public Connection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        properties.setProperty("connection.type", CONNECTION_TYPE);
        return this.getConnection(servers.iterator().next().getHostString(), properties);
    }

    private Connection getConnection(String serverName, Properties properties) throws ConnectionException {
        String connectionName;
        PassthroughServer server = PassthroughServerRegistry.getSharedInstance().getServerForName(serverName);
        if (null != server) {
            connectionName = properties.getProperty("connection.name");
            if (null == connectionName) {
                connectionName = "";
            }
        } else {
            throw new ConnectionException((Throwable)new UnknownHostException(serverName));
        }
        PassthroughConnection connection = server.connectNewClient(connectionName);
        return connection;
    }
}

