/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.concurrent.Future;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.PassthroughClientDescriptor;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughImplementationProvidedServiceProvider;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;

public class PassthroughCommunicatorService
implements ClientCommunicator {
    private final PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container;

    public PassthroughCommunicatorService(PassthroughImplementationProvidedServiceProvider.DeferredEntityContainer container) {
        Assert.assertTrue(null != container);
        this.container = container;
    }

    public void closeClientConnection(ClientDescriptor clientDescriptor) {
        PassthroughClientDescriptor rawDescriptor = (PassthroughClientDescriptor)clientDescriptor;
        PassthroughConnection connection = rawDescriptor.sender;
        connection.close();
    }

    public void sendNoResponse(ClientDescriptor clientDescriptor, EntityResponse message) throws MessageCodecException {
        this.prepareAndSendMessage(clientDescriptor, message);
    }

    private Future<Void> prepareAndSendMessage(ClientDescriptor clientDescriptor, EntityResponse entityMessage) throws MessageCodecException {
        PassthroughClientDescriptor rawDescriptor = (PassthroughClientDescriptor)clientDescriptor;
        PassthroughConnection connection = rawDescriptor.sender;
        long clientInstanceID = rawDescriptor.clientInstanceID;
        Future<Void> waiter = connection.createClientResponseFuture();
        CommonServerEntity<?, ?> entity = this.container.getEntity();
        Assert.assertTrue(null != entity);
        byte[] payload = this.serialize(this.container.codec, entityMessage);
        PassthroughMessage message = PassthroughMessageCodec.createMessageToClient(clientInstanceID, payload);
        connection.sendMessageToClient(rawDescriptor.server, message.asSerializedBytes());
        return waiter;
    }

    private <R extends EntityResponse> byte[] serialize(MessageCodec<?, R> codec, EntityResponse message) throws MessageCodecException {
        return codec.encodeResponse(message);
    }
}

