/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.terracotta.monitoring.PlatformService;
import org.terracotta.monitoring.PlatformStopException;
import org.terracotta.passthrough.Assert;
import org.terracotta.passthrough.IClusterControl;
import org.terracotta.passthrough.PassthroughServer;
import org.terracotta.passthrough.PassthroughServerCrasher;
import org.terracotta.passthrough.PassthroughServerProcess;
import org.terracotta.passthrough.PassthroughServerRegistry;

public class PassthroughClusterControl
implements IClusterControl {
    private final String stripeName;
    private List<PassthroughServer> passthroughServers = new ArrayList<PassthroughServer>();
    private List<PassthroughServer> stoppedPassthroughServers = new ArrayList<PassthroughServer>();
    private PassthroughServer activeServer;
    private PassthroughServer mostRecentlyStoppedActiveServer;
    private final PassthroughServerCrasher crasher;

    public PassthroughClusterControl(String stripeName, PassthroughServer passthroughServer, PassthroughServer ... passthroughServers) {
        this.stripeName = stripeName;
        this.crasher = new PassthroughServerCrasher(this);
        this.crasher.start();
        Assert.assertTrue(passthroughServer != null);
        this.passthroughServers.add(passthroughServer);
        passthroughServer.registerAsynchronousServerCrasher(this.crasher);
        for (PassthroughServer ps : passthroughServers) {
            Assert.assertTrue(ps != null);
            this.passthroughServers.add(ps);
            ps.setClusterControl(this);
            ps.registerAsynchronousServerCrasher(this.crasher);
        }
        this.bootstrapCluster();
    }

    public synchronized void waitForActive() throws Exception {
        while (this.activeServer == null) {
            this.wait();
        }
    }

    public void startOneServerWithConsistency() throws Exception {
        this.startOneServer();
    }

    public void startAllServersWithConsistency() throws Exception {
        this.startAllServers();
    }

    public synchronized void waitForRunningPassivesInStandby() throws Exception {
        while (this.activeServer == null) {
            this.wait();
        }
    }

    public synchronized void startOneServer() {
        this.internalStartOneServer();
    }

    private void internalStartOneServer() {
        try {
            PassthroughServer terminatedServer = this.stoppedPassthroughServers.remove(0);
            this.startTerminatedServer(terminatedServer);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("There are no terminated servers to start");
        }
    }

    public synchronized void startAllServers() {
        while (!this.stoppedPassthroughServers.isEmpty()) {
            PassthroughServer terminatedServer = this.stoppedPassthroughServers.remove(0);
            this.startTerminatedServer(terminatedServer);
        }
    }

    public synchronized void terminateActive() {
        this.internalTerminateActive();
    }

    public synchronized void terminateOnePassive() {
        PassthroughServer victim = null;
        for (PassthroughServer candidate : this.passthroughServers) {
            if (candidate == this.activeServer || this.stoppedPassthroughServers.contains(candidate)) continue;
            victim = candidate;
            break;
        }
        if (null != victim) {
            this.internalTerminatePassive(victim);
        }
    }

    private void internalTerminatePassive(PassthroughServer victim) {
        if (null != this.activeServer) {
            this.activeServer.detachDownstreamPassive(victim);
        }
        victim.stop();
        this.stoppedPassthroughServers.add(victim);
    }

    public synchronized void terminateAllServers() {
        if (null != this.activeServer) {
            this.activeServer.disconnectClients();
            this.activeServer.stop();
            Assert.assertTrue(PassthroughServerRegistry.getSharedInstance().unregisterServer(this.stripeName) == this.activeServer);
            this.stoppedPassthroughServers.add(this.activeServer);
            this.activeServer = null;
        }
        for (PassthroughServer candidate : this.passthroughServers) {
            if (this.stoppedPassthroughServers.contains(candidate)) continue;
            candidate.stop();
            this.stoppedPassthroughServers.add(candidate);
        }
    }

    public synchronized void restartOneServerFromInside(PassthroughServerProcess victim) {
        for (PassthroughServer candidate : this.passthroughServers) {
            if (this.stoppedPassthroughServers.contains(candidate) || !candidate.isRunningProcess(victim)) continue;
            if (candidate == this.activeServer) {
                this.internalTerminateActive();
            } else {
                this.internalTerminatePassive(candidate);
            }
            this.internalStartOneServer();
            break;
        }
    }

    public void tearDown() {
        this.crasher.waitForStop();
        PassthroughServer removedServer = PassthroughServerRegistry.getSharedInstance().unregisterServer(this.stripeName);
        Assert.assertTrue(this.activeServer == removedServer);
        for (PassthroughServer passthroughServer : this.passthroughServers) {
            if (this.stoppedPassthroughServers.contains(passthroughServer)) continue;
            passthroughServer.stop();
        }
    }

    private synchronized void bootstrapCluster() {
        Assert.assertTrue(this.activeServer == null);
        PassthroughServer electedActive = this.electActive();
        boolean isActive = true;
        boolean shouldStorageLoaded = false;
        electedActive.start(isActive, shouldStorageLoaded, Collections.emptySet());
        for (PassthroughServer passthroughServer : this.passthroughServers) {
            if (electedActive.equals(passthroughServer)) continue;
            passthroughServer.start(!isActive, shouldStorageLoaded, Collections.emptySet());
        }
        this.attachPassivesToActive(electedActive);
        PassthroughServer prevActive = PassthroughServerRegistry.getSharedInstance().registerServer(this.stripeName, electedActive);
        Assert.assertTrue(prevActive == null);
        this.activeServer = electedActive;
        this.notifyAll();
    }

    private PassthroughServer electActive() {
        ArrayList<PassthroughServer> eligibleServers = new ArrayList<PassthroughServer>();
        for (PassthroughServer passthroughServer : this.passthroughServers) {
            if (this.stoppedPassthroughServers.contains(passthroughServer)) continue;
            eligibleServers.add(passthroughServer);
        }
        PassthroughServer activeServer = null;
        if (eligibleServers.size() > 0) {
            int random = (int)(Math.random() * (double)eligibleServers.size());
            activeServer = (PassthroughServer)eligibleServers.get(random);
        }
        return activeServer;
    }

    private void attachPassivesToActive(PassthroughServer activeServer) {
        for (PassthroughServer passthroughServer : this.passthroughServers) {
            if (this.stoppedPassthroughServers.contains(passthroughServer) || activeServer.equals(passthroughServer)) continue;
            activeServer.attachDownstreamPassive(passthroughServer);
        }
    }

    private void startTerminatedServer(PassthroughServer lastTerminatedServer) {
        if (this.activeServer != null) {
            boolean isActive = false;
            boolean shouldStorageLoaded = false;
            lastTerminatedServer.start(isActive, shouldStorageLoaded, Collections.emptySet());
            this.activeServer.attachDownstreamPassive(lastTerminatedServer);
        } else {
            boolean isActive = true;
            boolean shouldStorageLoaded = true;
            Assert.assertTrue(null != this.mostRecentlyStoppedActiveServer);
            lastTerminatedServer.start(isActive, shouldStorageLoaded, this.mostRecentlyStoppedActiveServer.getSavedClientConnections());
            this.attachPassivesToActive(lastTerminatedServer);
            this.mostRecentlyStoppedActiveServer.connectSavedClientsTo(lastTerminatedServer);
            this.mostRecentlyStoppedActiveServer = null;
            PassthroughServer prevActive = PassthroughServerRegistry.getSharedInstance().registerServer(this.stripeName, lastTerminatedServer);
            Assert.assertTrue(prevActive == null);
            this.activeServer = lastTerminatedServer;
            this.notifyAll();
        }
    }

    private void internalTerminateActive() {
        Assert.assertTrue(this.activeServer != null);
        PassthroughServer prevActiveServer = this.activeServer;
        this.activeServer = null;
        prevActiveServer.disconnectClients();
        prevActiveServer.stop();
        Assert.assertTrue(PassthroughServerRegistry.getSharedInstance().unregisterServer(this.stripeName) == prevActiveServer);
        this.stoppedPassthroughServers.add(prevActiveServer);
        PassthroughServer electedActive = this.electActive();
        if (electedActive != null) {
            electedActive.promoteToActive();
            this.attachPassivesToActive(electedActive);
            prevActiveServer.connectSavedClientsTo(electedActive);
            PassthroughServer prevActive = PassthroughServerRegistry.getSharedInstance().registerServer(this.stripeName, electedActive);
            Assert.assertTrue(prevActive == null);
            this.activeServer = electedActive;
            this.notifyAll();
        } else {
            Assert.assertTrue(null == this.mostRecentlyStoppedActiveServer);
            this.mostRecentlyStoppedActiveServer = prevActiveServer;
        }
    }

    synchronized void terminateIfActive(PassthroughServer passthroughServer, PlatformService.RestartMode restartMode) throws PlatformStopException {
        if (this.activeServer != passthroughServer) {
            throw new PlatformStopException("Server is not in active state");
        }
        this.internalTerminateActive();
        this.startIfNeeded(passthroughServer, restartMode);
    }

    synchronized void terminateIfPassive(PassthroughServer passthroughServer, PlatformService.RestartMode restartMode) throws PlatformStopException {
        if (this.activeServer != passthroughServer) {
            if (!this.stoppedPassthroughServers.contains(passthroughServer)) {
                this.internalTerminatePassive(passthroughServer);
                this.startIfNeeded(passthroughServer, restartMode);
            }
        } else {
            throw new PlatformStopException("Server is not in passive state");
        }
    }

    synchronized void terminate(PassthroughServer passthroughServer, PlatformService.RestartMode restartMode) {
        if (this.activeServer == passthroughServer) {
            this.internalTerminateActive();
        } else if (!this.stoppedPassthroughServers.contains(passthroughServer)) {
            this.internalTerminatePassive(passthroughServer);
            this.startIfNeeded(passthroughServer, restartMode);
        }
    }

    private synchronized void startIfNeeded(PassthroughServer passthroughServer, PlatformService.RestartMode restartMode) {
        if (restartMode == PlatformService.RestartMode.STOP_AND_RESTART) {
            this.stoppedPassthroughServers.remove(passthroughServer);
            this.startTerminatedServer(passthroughServer);
        }
    }
}

