/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.passthrough.PassthroughClientSourceId;
import org.terracotta.passthrough.PassthroughConnection;
import org.terracotta.passthrough.PassthroughServerProcess;

public class PassthroughClientDescriptor
implements ClientDescriptor {
    public final PassthroughServerProcess server;
    public PassthroughConnection sender;
    public long clientInstanceID;

    public PassthroughClientDescriptor(PassthroughServerProcess server, PassthroughConnection sender, long clientInstanceID) {
        this.server = server;
        this.sender = sender;
        this.clientInstanceID = clientInstanceID;
    }

    public int hashCode() {
        int result = this.sender != null ? Long.hashCode(this.sender.getUniqueConnectionID()) : 0;
        result = 31 * result + Long.hashCode(this.clientInstanceID);
        return result;
    }

    public boolean isValidClient() {
        return this.sender != null;
    }

    public ClientSourceId getSourceId() {
        return new PassthroughClientSourceId(this.sender == null ? -1L : this.sender.getUniqueConnectionID());
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = obj == this;
        if (!isEqual && obj instanceof PassthroughClientDescriptor) {
            PassthroughClientDescriptor other = (PassthroughClientDescriptor)obj;
            isEqual = other.sender.getUniqueConnectionID() == this.sender.getUniqueConnectionID() && other.clientInstanceID == this.clientInstanceID;
        }
        return isEqual;
    }

    public String toString() {
        String ret = "PassthroughClientDescriptor{server=";
        ret = ret + (this.server != null ? this.server.toString() : "<no server>");
        ret = ret + "," + (this.sender != null ? this.sender.toString() : "<no sender>");
        ret = ret + ",clientInstanceID=" + this.clientInstanceID + '}';
        return ret;
    }
}

