/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough;

import java.util.Properties;
import org.terracotta.entity.ActiveInvokeChannel;
import org.terracotta.entity.ActiveInvokeContext;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.passthrough.IMessageSenderWrapper;
import org.terracotta.passthrough.PassThroughServerInvokeContext;
import org.terracotta.passthrough.PassthroughMessage;
import org.terracotta.passthrough.PassthroughMessageCodec;
import org.terracotta.passthrough.PassthroughRetirementManager;

public class PassThroughServerActiveInvokeContext<M extends EntityMessage, R extends EntityResponse>
extends PassThroughServerInvokeContext
implements ActiveInvokeContext<R> {
    private final MessageCodec<M, R> codec;
    private final EntityMessage message;
    private final ClientDescriptor descriptor;
    private final IMessageSenderWrapper monitor;
    private final PassthroughRetirementManager retirement;

    public PassThroughServerActiveInvokeContext(M message, ClientDescriptor descriptor, int concurrencyKey, long current, long oldest, IMessageSenderWrapper monitor, PassthroughRetirementManager retirement, MessageCodec<M, R> codec) {
        super(descriptor == null ? null : descriptor.getSourceId(), concurrencyKey, current, oldest);
        this.message = message;
        this.descriptor = descriptor;
        this.monitor = monitor;
        this.retirement = retirement;
        this.codec = codec;
    }

    public ClientDescriptor getClientDescriptor() {
        return this.descriptor;
    }

    public ActiveInvokeChannel<R> openInvokeChannel() {
        this.monitor.open();
        return new ActiveInvokeChannel<R>(){

            public void sendResponse(R response) {
                try {
                    byte[] r = PassThroughServerActiveInvokeContext.this.codec.encodeResponse(response);
                    PassthroughMessage msg = PassthroughMessageCodec.createMonitorMessage(r, null);
                    msg.setTransactionTracking(PassThroughServerActiveInvokeContext.this.getCurrentTransactionId(), PassThroughServerActiveInvokeContext.this.getOldestTransactionId());
                    PassThroughServerActiveInvokeContext.this.monitor.sendComplete(msg, false);
                }
                catch (MessageCodecException codec) {
                    throw new RuntimeException(codec);
                }
            }

            public void sendException(Exception excptn) {
                EntityException exp = excptn instanceof EntityException ? (EntityException)((Object)excptn) : new EntityServerException(null, null, null, (Throwable)excptn);
                PassthroughMessage msg = PassthroughMessageCodec.createMonitorMessage(null, exp);
                msg.setTransactionTracking(PassThroughServerActiveInvokeContext.this.getCurrentTransactionId(), PassThroughServerActiveInvokeContext.this.getOldestTransactionId());
                PassThroughServerActiveInvokeContext.this.monitor.sendComplete(msg, false);
            }

            public void close() {
                PassThroughServerActiveInvokeContext.this.monitor.close();
            }
        };
    }

    public Properties getClientSourceProperties() {
        Properties props = new Properties();
        props.setProperty("clientID", String.valueOf(this.descriptor.getSourceId()));
        return props;
    }
}

