/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.passthrough.connection;

import com.tc.classloader.OverrideService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionService;

@OverrideService(value="org.terracotta.lease.connection.LeasedConnectionServiceImpl")
public class PassthroughLeasedConnectionService
implements LeasedConnectionService {
    public boolean handlesURI(URI uri) {
        return this.handlesConnectionType(uri.getScheme());
    }

    public boolean handlesConnectionType(String connectionType) {
        return connectionType.equals("passthrough") || connectionType.equals("terracotta") || connectionType.equals("mock");
    }

    public LeasedConnection connect(URI uri, Properties properties) throws ConnectionException {
        return new PassthroughLeasedConnection(ConnectionFactory.connect((URI)uri, (Properties)properties));
    }

    public LeasedConnection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        return new PassthroughLeasedConnection(ConnectionFactory.connect(servers, (Properties)properties));
    }

    static class PassthroughLeasedConnection
    implements LeasedConnection {
        private final Connection connection;

        PassthroughLeasedConnection(Connection connection) {
            this.connection = connection;
        }

        public <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
            return this.connection.getEntityRef(cls, version, name);
        }

        public void close() throws IOException {
            this.connection.close();
        }

        public boolean isValid() {
            return this.connection.isValid();
        }
    }
}

