/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable.portability;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.frs.object.heap.HeapValueSortedMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.offheapstore.storage.portability.SerializablePortability;
import org.terracotta.offheapstore.util.ByteBufferInputStream;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;
import org.terracotta.offheapstore.util.Validation;

public class RestartableSerializablePortability<I>
extends SerializablePortability
implements ObjectManagerStripe<I, ByteBuffer, ByteBuffer>,
ObjectManagerSegment<I, ByteBuffer, ByteBuffer>,
RestartableObject<I, ByteBuffer, ByteBuffer> {
    private static final boolean VALIDATING = Validation.shouldValidate(RestartableSerializablePortability.class);
    private final I identifier;
    private final RestartStore<I, ByteBuffer, ByteBuffer> restartability;
    private final HeapValueSortedMap<Integer, Long> lsnMap = new HeapValueSortedMap();
    private final Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> segments;
    private final boolean synchronous;
    private ObjectManagerEntry<I, ByteBuffer, ByteBuffer> compactingEntry;
    private long sizeInBytes = 0L;

    public RestartableSerializablePortability(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> restartability, boolean synchronous) {
        this.identifier = identifier;
        this.restartability = restartability;
        this.segments = Collections.singleton(this);
        this.synchronous = synchronous;
    }

    public RestartableSerializablePortability(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> restartability, boolean synchronous, ClassLoader classLoader) {
        super(classLoader);
        this.identifier = identifier;
        this.restartability = restartability;
        this.segments = Collections.singleton(this);
        this.synchronous = synchronous;
    }

    @Override
    protected void addedMapping(Integer rep, ObjectStreamClass disconnected) {
        try {
            this.restartability.beginTransaction(this.synchronous).put(this.identifier, (Object)RestartableSerializablePortability.encodeInteger(rep), (Object)RestartableSerializablePortability.encodeObjectStreamClass(disconnected)).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public Long getLowestLsn() {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return (Long)this.lsnMap.firstValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public Long getLsn(ByteBuffer key) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return (Long)this.lsnMap.get((Object)RestartableSerializablePortability.decodeInteger(key));
        }
    }

    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public Long getLsn(int hash, ByteBuffer key) {
        return this.getLsn(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void put(ByteBuffer key, ByteBuffer value, long lsn) {
        int representation = RestartableSerializablePortability.decodeInteger(key);
        if (this.lookup.containsKey(representation)) {
            ConcurrentMap concurrentMap = this.lookup;
            synchronized (concurrentMap) {
                this.sizeInBytes += (long)(key.remaining() + value.remaining());
                this.lsnMap.put((Object)representation, (Comparable)Long.valueOf(lsn));
            }
        } else {
            throw new AssertionError();
        }
    }

    public void put(int hash, ByteBuffer key, ByteBuffer value, long lsn) {
        this.put(key, value, lsn);
    }

    public void remove(ByteBuffer key) {
        throw new AssertionError();
    }

    public void remove(int hash, ByteBuffer key) {
        this.remove(key);
    }

    public void delete() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void replayPut(ByteBuffer binaryKey, ByteBuffer binaryValue, long lsn) {
        try {
            int representation = RestartableSerializablePortability.decodeInteger(binaryKey);
            ObjectStreamClass osc = RestartableSerializablePortability.decodeObjectStreamClass(binaryValue);
            SerializablePortability.SerializableDataKey key = new SerializablePortability.SerializableDataKey(osc, true);
            ConcurrentMap concurrentMap = this.lookup;
            synchronized (concurrentMap) {
                this.sizeInBytes += (long)(binaryKey.remaining() + binaryValue.remaining());
                ObjectStreamClass oldOsc = this.lookup.putIfAbsent(representation, osc);
                Integer oldRep = this.lookup.putIfAbsent(key, representation);
                this.lsnMap.put((Object)representation, (Comparable)Long.valueOf(lsn));
                if (oldRep != null && !oldRep.equals(representation)) {
                    throw new AssertionError((Object)"Existing colliding class mapping detected");
                }
                if (oldOsc != null && !oldOsc.getName().equals(osc.getName())) {
                    throw new AssertionError((Object)"Existing colliding class mapping detected");
                }
                this.nextStreamIndex = Math.max(this.nextStreamIndex, representation + 1);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void replayPut(int hash, ByteBuffer key, ByteBuffer value, long lsn) {
        this.replayPut(key, value, lsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public ObjectManagerEntry<I, ByteBuffer, ByteBuffer> acquireCompactionEntry(long ceilingLsn) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            if (this.compactingEntry != null) {
                throw new AssertionError((Object)("Compaction Entry Already Acquired : " + this.compactingEntry));
            }
            Integer key = (Integer)this.lsnMap.firstKey();
            if (key == null) {
                return null;
            }
            long lsn = (Long)this.lsnMap.get((Object)key);
            if (lsn >= ceilingLsn) {
                return null;
            }
            ByteBuffer value = RestartableSerializablePortability.encodeObjectStreamClass((ObjectStreamClass)this.lookup.get(key));
            this.compactingEntry = new SimpleObjectManagerEntry(this.identifier, (Object)RestartableSerializablePortability.encodeInteger(key), (Object)value, lsn);
            return this.compactingEntry;
        }
    }

    public void updateLsn(int pojoHash, ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        this.updateLsn(entry, newLsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void updateLsn(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            if (entry != this.compactingEntry) {
                throw new IllegalArgumentException("Tried to update the LSN on an entry that was not first acquired.");
            }
            int i = RestartableSerializablePortability.decodeInteger((ByteBuffer)entry.getKey());
            Long previous = (Long)this.lsnMap.get((Object)i);
            Validation.validate(!VALIDATING || previous.longValue() == entry.getLsn());
            this.lsnMap.put((Object)i, (Comparable)Long.valueOf(newLsn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void releaseCompactionEntry(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            if (entry == null) {
                throw new NullPointerException("Tried to release a null entry.");
            }
            if (entry != this.compactingEntry) {
                throw new AssertionError((Object)"Released entry was not previously acquired.");
            }
            this.compactingEntry = null;
        }
    }

    public Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> getSegments() {
        return this.segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public long size() {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return this.lsnMap.size();
        }
    }

    private static ByteBuffer encodeInteger(int integer) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(integer);
        return (ByteBuffer)buffer.flip();
    }

    private static int decodeInteger(ByteBuffer data) {
        return data.getInt(0);
    }

    private static ByteBuffer encodeObjectStreamClass(ObjectStreamClass osc) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = new ObjectOutputStream(bout);){
            oout.writeObject(osc);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectStreamClass decodeObjectStreamClass(ByteBuffer data) {
        ObjectStreamClass objectStreamClass;
        ByteBufferInputStream bin = new ByteBufferInputStream(data.duplicate());
        ObjectInputStream oin = new ObjectInputStream(bin){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return null;
            }
        };
        try {
            objectStreamClass = (ObjectStreamClass)oin.readObject();
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        oin.close();
        return objectStreamClass;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public I getId() {
        return this.identifier;
    }

    public ObjectManagerStripe<I, ByteBuffer, ByteBuffer> getObjectManagerStripe() {
        return this;
    }
}

