/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.HashingMap;
import org.terracotta.offheapstore.MapInternals;
import org.terracotta.offheapstore.MetadataTuple;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.Page;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.BinaryStorageEngine;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.util.DebuggingUtils;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;
import org.terracotta.offheapstore.util.NoOpLock;
import org.terracotta.offheapstore.util.WeakIdentityHashMap;

public class OffHeapHashMap<K, V>
extends AbstractMap<K, V>
implements MapInternals,
StorageEngine.Owner,
HashingMap<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapHashMap.class);
    private static final int INITIAL_TABLE_SIZE = 128;
    private static final float TABLE_RESIZE_THRESHOLD = 0.5f;
    private static final float TABLE_SHRINK_THRESHOLD = 0.2f;
    private static final int INITIAL_REPROBE_LENGTH = 16;
    private static final int REPROBE_WARNING_THRESHOLD = 1024;
    private static final int ALLOCATE_ON_CLEAR_THRESHOLD_RATIO = 2;
    private static final IntBuffer DESTROYED_TABLE = IntBuffer.allocate(0);
    protected static final int ENTRY_SIZE = 4;
    protected static final int ENTRY_BIT_SHIFT = Integer.numberOfTrailingZeros(4);
    protected static final int STATUS = 0;
    protected static final int KEY_HASHCODE = 1;
    protected static final int ENCODING = 2;
    protected static final int STATUS_USED = 1;
    protected static final int STATUS_REMOVED = 2;
    public static final int RESERVED_STATUS_BITS = 3;
    protected final StorageEngine<? super K, ? super V> storageEngine;
    protected final PageSource tableSource;
    private final WeakIdentityHashMap<IntBuffer, PendingPage> pendingTableFrees = new WeakIdentityHashMap(pending -> this.freeTable(pending.tablePage));
    private final int initialTableSize;
    private final boolean tableAllocationsSteal;
    private final ThreadLocal<Boolean> tableResizing = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected volatile int size;
    protected volatile int modCount;
    protected int reprobeLimit = 16;
    private float currentTableShrinkThreshold = 0.2f;
    private volatile boolean hasUsedIterators;
    protected volatile IntBuffer hashtable;
    protected volatile Page hashTablePage;
    private Set<Map.Entry<K, V>> entrySet;
    private Set<K> keySet;
    private Set<Long> encodingSet;
    protected volatile int removedSlots;

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        this(source, storageEngine, 128);
    }

    public OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine) {
        this(source, tableAllocationsSteal, storageEngine, 128);
    }

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        this(source, false, storageEngine, 128, bootstrap);
    }

    public OffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        this(source, false, storageEngine, tableSize, true);
    }

    public OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        this(source, tableAllocationsSteal, storageEngine, tableSize, true);
    }

    @FindbugsSuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"})
    protected OffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        int capacity;
        if (storageEngine == null) {
            throw new NullPointerException("StorageEngine implementation must be non-null");
        }
        this.storageEngine = storageEngine;
        this.tableSource = source;
        this.tableAllocationsSteal = tableAllocationsSteal;
        for (capacity = 1; capacity < tableSize; capacity <<= 1) {
        }
        this.initialTableSize = capacity;
        if (bootstrap) {
            this.hashTablePage = this.allocateTable(this.initialTableSize);
            if (this.hashTablePage == null) {
                String msg = "Initial table allocation failed.\nInitial Table Size (slots) : " + this.initialTableSize + '\n' + "Allocation Will Require    : " + DebuggingUtils.toBase2SuffixedString(this.initialTableSize * 4 * 4) + "B\nTable Page Source        : " + this.tableSource;
                throw new IllegalArgumentException(msg);
            }
            this.hashtable = this.hashTablePage.asIntBuffer();
        }
        this.storageEngine.bind(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = key.hashCode();
        if (this.size == 0) {
            return false;
        }
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!view.hasRemaining()) {
                view.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)view.slice().limit(4))) {
                return false;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                this.hit(entry);
                return true;
            }
            view.position(view.position() + 4);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int hash = key.hashCode();
        if (this.size == 0) {
            return null;
        }
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!view.hasRemaining()) {
                view.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)view.slice().limit(4))) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                this.hit(entry);
                return this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
            }
            view.position(view.position() + 4);
        }
        return null;
    }

    @Override
    public Long getEncodingForHashAndBinary(int hash, ByteBuffer binaryKey) {
        if (this.size == 0) {
            return null;
        }
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!view.hasRemaining()) {
                view.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)view.slice().limit(4))) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.binaryKeyEquals(binaryKey, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                return OffHeapHashMap.readLong(entry, 2);
            }
            view.position(view.position() + 4);
        }
        return null;
    }

    @Override
    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public long installMappingForHashAndEncoding(int pojoHash, ByteBuffer offheapBinaryKey, ByteBuffer offheapBinaryValue, int metadata) {
        this.freePendingTables();
        int[] newEntry = this.installEntry(offheapBinaryKey, pojoHash, offheapBinaryValue, metadata);
        int start = this.indexFor(OffHeapHashMap.spread(pojoHash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                if (OffHeapHashMap.isRemoved(entry)) {
                    --this.removedSlots;
                }
                entry.put(newEntry);
                this.slotAdded(entry);
                this.hit(entry);
                return OffHeapHashMap.readLong(newEntry, 2);
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
        this.expand(start, limit);
        return this.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
    }

    public Integer getMetadata(Object key, int mask) {
        int safeMask = mask & 0xFFFFFFFC;
        this.freePendingTables();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
            long encoding = OffHeapHashMap.readLong(entry, 2);
            if (OffHeapHashMap.isTerminating(entry)) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, encoding, entry.get(1))) {
                return entry.get(0) & safeMask;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return null;
    }

    public Integer getAndSetMetadata(Object key, int mask, int values) {
        int safeMask = mask & 0xFFFFFFFC;
        this.freePendingTables();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
            long encoding = OffHeapHashMap.readLong(entry, 2);
            if (OffHeapHashMap.isTerminating(entry)) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, encoding, entry.get(1))) {
                int previous = entry.get(0);
                entry.put(0, previous & ~safeMask | values & safeMask);
                return previous & safeMask;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return null;
    }

    public V getValueAndSetMetadata(Object key, int mask, int values) {
        int safeMask = mask & 0xFFFFFFFC;
        this.freePendingTables();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
            long encoding = OffHeapHashMap.readLong(entry, 2);
            if (OffHeapHashMap.isTerminating(entry)) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, encoding, entry.get(1))) {
                this.hit(entry);
                entry.put(0, entry.get(0) & ~safeMask | values & safeMask);
                V result = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                return result;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, 0);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public V put(K key, V value, int metadata) {
        this.freePendingTables();
        int hash = key.hashCode();
        int[] newEntry = this.writeEntry(key, hash, value, metadata);
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, metadata);
                this.storageEngine.invalidateCache();
                IntBuffer laterEntry = entry;
                while (i < limit && !OffHeapHashMap.isTerminating(laterEntry)) {
                    if (OffHeapHashMap.isPresent(laterEntry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1))) {
                        V old = this.storageEngine.readValue(OffHeapHashMap.readLong(laterEntry, 2));
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1), false);
                        long oldEncoding = OffHeapHashMap.readLong(laterEntry, 2);
                        laterEntry.put(newEntry);
                        this.slotUpdated((IntBuffer)laterEntry.flip(), oldEncoding);
                        this.hit(laterEntry);
                        return old;
                    }
                    this.hashtable.position(this.hashtable.position() + 4);
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    laterEntry = (IntBuffer)this.hashtable.slice().limit(4);
                    ++i;
                }
                if (OffHeapHashMap.isRemoved(entry)) {
                    --this.removedSlots;
                }
                entry.put(newEntry);
                this.slotAdded(entry);
                this.hit(entry);
                return null;
            }
            if (this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, metadata);
                this.storageEngine.invalidateCache();
                V old = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), false);
                long oldEncoding = OffHeapHashMap.readLong(entry, 2);
                entry.put(newEntry);
                this.slotUpdated((IntBuffer)entry.flip(), oldEncoding);
                this.hit(entry);
                return old;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
        this.expand(start, limit);
        return this.put(key, value, metadata);
    }

    public V fill(K key, V value) {
        return this.fill(key, value, 0);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public V fill(K key, V value, int metadata) {
        this.freePendingTables();
        int hash = key.hashCode();
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                IntBuffer laterEntry = entry;
                while (i < limit && !OffHeapHashMap.isTerminating(laterEntry)) {
                    if (OffHeapHashMap.isPresent(laterEntry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1))) {
                        return this.put(key, value, metadata);
                    }
                    this.hashtable.position(this.hashtable.position() + 4);
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    laterEntry = (IntBuffer)this.hashtable.slice().limit(4);
                    ++i;
                }
                int[] newEntry = this.tryWriteEntry(key, hash, value, metadata);
                if (newEntry == null) {
                    return null;
                }
                return this.fill(key, value, hash, newEntry, metadata);
            }
            if (this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                return this.put(key, value, metadata);
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        if (this.tryExpandTable()) {
            return this.fill(key, value, metadata);
        }
        return null;
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    protected final V fill(K key, V value, int hash, int[] newEntry, int metadata) {
        this.freePendingTables();
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, metadata);
                this.storageEngine.invalidateCache();
                IntBuffer laterEntry = entry;
                while (i < limit && !OffHeapHashMap.isTerminating(laterEntry)) {
                    if (OffHeapHashMap.isPresent(laterEntry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1))) {
                        V old = this.storageEngine.readValue(OffHeapHashMap.readLong(laterEntry, 2));
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1), false);
                        long oldEncoding = OffHeapHashMap.readLong(laterEntry, 2);
                        laterEntry.put(newEntry);
                        this.slotUpdated((IntBuffer)laterEntry.flip(), oldEncoding);
                        this.hit(laterEntry);
                        return old;
                    }
                    this.hashtable.position(this.hashtable.position() + 4);
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    laterEntry = (IntBuffer)this.hashtable.slice().limit(4);
                    ++i;
                }
                if (OffHeapHashMap.isRemoved(entry)) {
                    --this.removedSlots;
                }
                entry.put(newEntry);
                this.slotAdded(entry);
                this.hit(entry);
                return null;
            }
            if (this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, metadata);
                this.storageEngine.invalidateCache();
                V old = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), false);
                long oldEncoding = OffHeapHashMap.readLong(entry, 2);
                entry.put(newEntry);
                this.slotUpdated((IntBuffer)entry.flip(), oldEncoding);
                this.hit(entry);
                return old;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], true);
        return null;
    }

    private int[] writeEntry(K key, int hash, V value, int metadata) {
        int[] entry;
        while ((entry = this.tryWriteEntry(key, hash, value, metadata)) == null) {
            this.storageEngineFailure(key);
        }
        return entry;
    }

    @FindbugsSuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private int[] tryWriteEntry(K key, int hash, V value, int metadata) {
        if (this.hashtable == null) {
            throw new NullPointerException();
        }
        if (this.hashtable == DESTROYED_TABLE) {
            throw new IllegalStateException("Offheap map/cache has been destroyed");
        }
        if ((metadata & 3) == 0) {
            Long encoding = this.storageEngine.writeMapping(key, value, hash, metadata);
            if (encoding == null) {
                return null;
            }
            return OffHeapHashMap.createEntry(hash, encoding, metadata);
        }
        throw new IllegalArgumentException("Invalid metadata for key '" + key + "' : " + Integer.toBinaryString(metadata));
    }

    private int[] installEntry(ByteBuffer offheapBinaryKey, int pojoHash, ByteBuffer offheapBinaryValue, int metadata) {
        int[] entry;
        while ((entry = this.tryInstallEntry(offheapBinaryKey, pojoHash, offheapBinaryValue, metadata)) == null) {
            this.storageEngineFailure("<binary-key>");
        }
        return entry;
    }

    @FindbugsSuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private int[] tryInstallEntry(ByteBuffer offheapBinaryKey, int pojoHash, ByteBuffer offheapBinaryValue, int metadata) {
        if (this.hashtable == null) {
            throw new NullPointerException();
        }
        if (this.hashtable == DESTROYED_TABLE) {
            throw new IllegalStateException("Offheap map/cache has been destroyed");
        }
        if ((metadata & 3) == 0) {
            Long encoding = ((BinaryStorageEngine)((Object)this.storageEngine)).writeBinaryMapping(offheapBinaryKey, offheapBinaryValue, pojoHash, metadata);
            if (encoding == null) {
                return null;
            }
            return OffHeapHashMap.createEntry(pojoHash, encoding, metadata);
        }
        throw new IllegalArgumentException("Invalid metadata for binary key : " + Integer.toBinaryString(metadata));
    }

    private static int[] createEntry(int hash, long encoding, int metadata) {
        return new int[]{1 | metadata, hash, (int)(encoding >>> 32), (int)encoding};
    }

    @Override
    public V remove(Object key) {
        this.freePendingTables();
        int hash = key.hashCode();
        if (this.size == 0) {
            return null;
        }
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                V removedValue = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), true);
                entry.put(0, 2);
                this.slotRemoved(entry);
                this.shrink();
                return removedValue;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return null;
    }

    @Override
    public Map<K, V> removeAllWithHash(int hash) {
        this.freePendingTables();
        if (this.size == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, V> removed = new HashMap<K, V>();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                return removed;
            }
            if (OffHeapHashMap.isPresent(entry) && hash == entry.get(1)) {
                V removedValue = this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
                K removedKey = this.storageEngine.readKey(OffHeapHashMap.readLong(entry, 2), hash);
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), true);
                removed.put(removedKey, removedValue);
                entry.put(0, 2);
                this.slotRemoved(entry);
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.shrink();
        return removed;
    }

    public boolean removeNoReturn(Object key) {
        this.freePendingTables();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                return false;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), true);
                entry.put(0, 2);
                this.slotRemoved(entry);
                this.shrink();
                return true;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return false;
    }

    @Override
    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void clear() {
        if (this.hashtable != DESTROYED_TABLE) {
            this.freePendingTables();
            ++this.modCount;
            this.removedSlots = 0;
            this.size = 0;
            this.storageEngine.clear();
            this.allocateOrClearTable(this.initialTableSize);
        }
    }

    public void destroy() {
        this.removedSlots = 0;
        this.size = 0;
        this.freeTable(this.hashTablePage);
        Iterator<PendingPage> it = this.pendingTableFrees.values();
        while (it.hasNext()) {
            this.freeTable(it.next().tablePage);
        }
        this.hashTablePage = null;
        this.hashtable = DESTROYED_TABLE;
        this.storageEngine.destroy();
    }

    private void allocateOrClearTable(int size) {
        Page newTablePage;
        int[] zeros = new int[256];
        this.hashtable.clear();
        while (this.hashtable.hasRemaining()) {
            if (this.hashtable.remaining() < zeros.length) {
                this.hashtable.put(zeros, 0, this.hashtable.remaining());
                continue;
            }
            this.hashtable.put(zeros);
        }
        this.hashtable.clear();
        this.wipePendingTables();
        if (this.hashtable.capacity() > size * 4 * 2 && (newTablePage = this.allocateTable(size)) != null) {
            this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
            this.hashTablePage = newTablePage;
            this.hashtable = newTablePage.asIntBuffer();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    public Set<Long> encodingSet() {
        EncodingSet es = this.encodingSet;
        return es == null ? (this.encodingSet = new EncodingSet()) : es;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    protected static boolean isPresent(IntBuffer entry) {
        return (entry.get(0) & 1) != 0;
    }

    protected static boolean isAvailable(IntBuffer entry) {
        return (entry.get(0) & 1) == 0;
    }

    protected static boolean isTerminating(IntBuffer entry) {
        return OffHeapHashMap.isTerminating(entry.get(0));
    }

    protected static boolean isTerminating(int entryStatus) {
        return (entryStatus & 3) == 0;
    }

    protected static boolean isRemoved(IntBuffer entry) {
        return OffHeapHashMap.isRemoved(entry.get(0));
    }

    protected static boolean isRemoved(int entryStatus) {
        return (entryStatus & 2) != 0;
    }

    protected static long readLong(int[] array, int offset) {
        return (long)array[offset] << 32 | 0xFFFFFFFFL & (long)array[offset + 1];
    }

    protected static long readLong(IntBuffer entry, int offset) {
        return (long)entry.get(offset) << 32 | 0xFFFFFFFFL & (long)entry.get(offset + 1);
    }

    protected int indexFor(int hash) {
        return OffHeapHashMap.indexFor(hash, this.hashtable);
    }

    protected static int indexFor(int hash, IntBuffer table) {
        return hash << ENTRY_BIT_SHIFT & Math.max(0, table.capacity() - 1);
    }

    private boolean keyEquals(Object probeKey, int probeHash, long targetEncoding, int targetHash) {
        return probeHash == targetHash && this.storageEngine.equalsKey(probeKey, targetEncoding);
    }

    private boolean binaryKeyEquals(ByteBuffer binaryProbeKey, int probeHash, long targetEncoding, int targetHash) {
        if (this.storageEngine instanceof BinaryStorageEngine) {
            return probeHash == targetHash && ((BinaryStorageEngine)((Object)this.storageEngine)).equalsBinaryKey(binaryProbeKey, targetEncoding);
        }
        throw new UnsupportedOperationException("Cannot check binary quality unless configured with a BinaryStorageEngine");
    }

    private void expand(int start, int length) {
        if (!this.tryExpand()) {
            this.tableExpansionFailure(start, length);
        }
    }

    private boolean tryExpand() {
        if ((float)this.size / (float)this.getTableCapacity() > 0.5f) {
            return this.tryExpandTable();
        }
        return this.tryIncreaseReprobe();
    }

    private boolean tryExpandTable() {
        if (this.tableResizing.get().booleanValue()) {
            throw new AssertionError((Object)"Expand requested in context of an existing resize - this should be impossible");
        }
        this.tableResizing.set(Boolean.TRUE);
        try {
            Page newTablePage = this.expandTable(1);
            if (newTablePage == null) {
                boolean bl = false;
                return bl;
            }
            this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
            this.hashTablePage = newTablePage;
            this.hashtable = newTablePage.asIntBuffer();
            this.removedSlots = 0;
            boolean bl = true;
            return bl;
        }
        finally {
            this.tableResizing.remove();
        }
    }

    private Page expandTable(int scale) {
        Page newTablePage;
        if (this.hashtable == DESTROYED_TABLE) {
            throw new IllegalStateException("This map/cache has been destroyed");
        }
        int newsize = this.hashtable.capacity() << scale;
        if (newsize <= 0) {
            return null;
        }
        long startTime = -1L;
        if (LOGGER.isDebugEnabled()) {
            startTime = System.nanoTime();
            int slots = this.hashtable.capacity() / 4;
            int newslots = newsize / 4;
            LOGGER.debug("Expanding table from {} slots to {} slots [load-factor={}]", new Object[]{DebuggingUtils.toBase2SuffixedString(slots), DebuggingUtils.toBase2SuffixedString(newslots), Float.valueOf((float)this.size / (float)slots)});
        }
        if ((newTablePage = this.allocateTable(newsize / 4)) == null) {
            return null;
        }
        IntBuffer newTable = newTablePage.asIntBuffer();
        this.hashtable.clear();
        while (this.hashtable.hasRemaining()) {
            IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
            if (OffHeapHashMap.isPresent(entry) && !this.writeEntry(newTable, entry)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table expansion from {} slots to {} slots abandoned - not enough table space", (Object)DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), (Object)DebuggingUtils.toBase2SuffixedString(newsize / 4));
                }
                this.freeTable(newTablePage);
                return this.expandTable(scale + 1);
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        if (LOGGER.isDebugEnabled()) {
            long time = System.nanoTime() - startTime;
            LOGGER.debug("Table expansion from {} slots to {} slots complete : took {}ms", new Object[]{DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), DebuggingUtils.toBase2SuffixedString(newsize / 4), Float.valueOf((float)time / 1000000.0f)});
        }
        return newTablePage;
    }

    protected boolean tryIncreaseReprobe() {
        if ((long)this.reprobeLimit() >= this.getTableCapacity()) {
            return false;
        }
        int newReprobeLimit = this.reprobeLimit() << 1;
        if (newReprobeLimit >= 1024) {
            long slots = this.getTableCapacity();
            LOGGER.warn("Expanding reprobe sequence from {} slots to {} slots [load-factor={}]", new Object[]{this.reprobeLimit(), newReprobeLimit, Float.valueOf((float)this.size / (float)slots)});
        } else if (LOGGER.isDebugEnabled()) {
            long slots = this.getTableCapacity();
            LOGGER.debug("Expanding reprobe sequence from {} slots to {} slots [load-factor={}]", new Object[]{this.reprobeLimit(), newReprobeLimit, Float.valueOf((float)this.size / (float)slots)});
        }
        this.reprobeLimit = newReprobeLimit;
        return true;
    }

    protected void shrinkTable() {
        this.shrink();
    }

    private void shrink() {
        if ((float)this.size / (float)this.getTableCapacity() <= this.currentTableShrinkThreshold) {
            this.shrinkTableImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkTableImpl() {
        if (this.tableResizing.get().booleanValue()) {
            LOGGER.debug("Shrink request ignored in the context of an in-process expand - likely self stealing");
        } else {
            this.tableResizing.set(Boolean.TRUE);
            try {
                float shrinkRatio = 0.5f * (float)this.getTableCapacity() / (float)this.size;
                int shrinkShift = Integer.numberOfTrailingZeros(Integer.highestOneBit(Math.max(2, (int)shrinkRatio)));
                Page newTablePage = this.shrinkTableImpl(shrinkShift);
                if (newTablePage == null) {
                    this.currentTableShrinkThreshold /= 2.0f;
                } else {
                    this.currentTableShrinkThreshold = 0.2f;
                    this.freeTable(this.hashTablePage, this.hashtable, this.reprobeLimit());
                    this.hashTablePage = newTablePage;
                    this.hashtable = newTablePage.asIntBuffer();
                    this.removedSlots = 0;
                }
            }
            finally {
                this.tableResizing.remove();
            }
        }
    }

    private Page shrinkTableImpl(int scale) {
        Page newTablePage;
        int newsize = this.hashtable.capacity() >>> scale;
        if (newsize < 4) {
            if (scale > 1) {
                return this.shrinkTableImpl(scale - 1);
            }
            return null;
        }
        long startTime = -1L;
        if (LOGGER.isDebugEnabled()) {
            startTime = System.nanoTime();
            int slots = this.hashtable.capacity() / 4;
            int newslots = newsize / 4;
            LOGGER.debug("Shrinking table from {} slots to {} slots [load-factor={}]", new Object[]{DebuggingUtils.toBase2SuffixedString(slots), DebuggingUtils.toBase2SuffixedString(newslots), Float.valueOf((float)this.size / (float)slots)});
        }
        if ((newTablePage = this.allocateTable(newsize / 4)) == null) {
            return null;
        }
        IntBuffer newTable = newTablePage.asIntBuffer();
        this.hashtable.clear();
        while (this.hashtable.hasRemaining()) {
            IntBuffer entry = (IntBuffer)this.hashtable.slice().limit(4);
            if (OffHeapHashMap.isPresent(entry) && !this.writeEntry(newTable, entry)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table shrinking from {} slots to {} slots abandoned - too little table space", (Object)DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), (Object)DebuggingUtils.toBase2SuffixedString(newsize / 4));
                }
                this.freeTable(newTablePage);
                if (scale > 1) {
                    return this.shrinkTableImpl(scale - 1);
                }
                this.hashtable.clear();
                return null;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        if (LOGGER.isDebugEnabled()) {
            long time = System.nanoTime() - startTime;
            LOGGER.debug("Table shrinking from {} slots to {} slots complete : took {}ms", new Object[]{DebuggingUtils.toBase2SuffixedString(this.hashtable.capacity() / 4), DebuggingUtils.toBase2SuffixedString(newsize / 4), Float.valueOf((float)time / 1000000.0f)});
        }
        return newTablePage;
    }

    private boolean writeEntry(IntBuffer table, IntBuffer entry) {
        int start = OffHeapHashMap.indexFor(OffHeapHashMap.spread(entry.get(1)), table);
        int tableMask = table.capacity() - 1;
        for (int i = 0; i < this.reprobeLimit() * 4; i += 4) {
            int address = start + i & tableMask;
            int existingStatus = table.get(address + 0);
            if (OffHeapHashMap.isTerminating(existingStatus)) {
                table.position(address);
                table.put(entry);
                return true;
            }
            if (OffHeapHashMap.isRemoved(existingStatus)) {
                throw new AssertionError();
            }
        }
        return false;
    }

    protected static int spread(int hash) {
        int h = hash;
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private Page allocateTable(int size) {
        Page newTablePage = this.tableSource.allocate(size * 4 * 4, this.tableAllocationsSteal, false, null);
        if (newTablePage != null) {
            ByteBuffer buffer = newTablePage.asByteBuffer();
            byte[] zeros = new byte[1024];
            buffer.clear();
            while (buffer.hasRemaining()) {
                if (buffer.remaining() < zeros.length) {
                    buffer.put(zeros, 0, buffer.remaining());
                    continue;
                }
                buffer.put(zeros);
            }
            buffer.clear();
        }
        return newTablePage;
    }

    private void freeTable(Page tablePage, IntBuffer table, int finalReprobe) {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.put(table, new PendingPage(tablePage, finalReprobe));
        } else {
            this.freeTable(tablePage);
        }
    }

    private void freeTable(Page tablePage) {
        this.tableSource.free(tablePage);
    }

    private int reprobeLimit() {
        return this.reprobeLimit;
    }

    protected void freePendingTables() {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.reap();
        }
    }

    private void updatePendingTables(int hash, long oldEncoding, IntBuffer newEntry) {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.reap();
            Iterator<PendingPage> it = this.pendingTableFrees.values();
            block0: while (it.hasNext()) {
                PendingPage pending = it.next();
                IntBuffer pendingTable = pending.tablePage.asIntBuffer();
                pendingTable.position(OffHeapHashMap.indexFor(OffHeapHashMap.spread(hash), pendingTable));
                for (int i = 0; i < pending.reprobe; ++i) {
                    IntBuffer entry;
                    if (!pendingTable.hasRemaining()) {
                        pendingTable.rewind();
                    }
                    if (OffHeapHashMap.isTerminating(entry = (IntBuffer)pendingTable.slice().limit(4))) continue block0;
                    if (OffHeapHashMap.isPresent(entry) && hash == entry.get(1) && oldEncoding == OffHeapHashMap.readLong(entry, 2)) {
                        entry.put(newEntry.duplicate());
                        continue block0;
                    }
                    pendingTable.position(pendingTable.position() + 4);
                }
            }
        }
    }

    private void wipePendingTables() {
        if (this.hasUsedIterators) {
            this.pendingTableFrees.reap();
            int[] zeros = new int[256];
            Iterator<PendingPage> it = this.pendingTableFrees.values();
            while (it.hasNext()) {
                PendingPage pending = it.next();
                IntBuffer pendingTable = pending.tablePage.asIntBuffer();
                pendingTable.clear();
                while (pendingTable.hasRemaining()) {
                    if (pendingTable.remaining() < zeros.length) {
                        pendingTable.put(zeros, 0, pendingTable.remaining());
                        continue;
                    }
                    pendingTable.put(zeros);
                }
                pendingTable.clear();
            }
        }
    }

    protected boolean removeMapping(Object o) {
        this.freePendingTables();
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        Object key = e.getKey();
        int hash = key.hashCode();
        this.hashtable.position(this.indexFor(OffHeapHashMap.spread(hash)));
        for (int i = 0; i < this.reprobeLimit(); ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                return false;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1)) && this.storageEngine.equalsValue(e.getValue(), OffHeapHashMap.readLong(entry, 2))) {
                this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), true);
                entry.put(0, 2);
                this.slotRemoved(entry);
                this.shrink();
                return true;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return false;
    }

    @Override
    public boolean evict(int index, boolean shrink) {
        return false;
    }

    protected void removeAtTableOffset(int offset, boolean shrink) {
        IntBuffer entry = ((IntBuffer)this.hashtable.duplicate().position(offset).limit(offset + 4)).slice();
        if (OffHeapHashMap.isPresent(entry)) {
            this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), true);
            entry.put(0, 2);
            this.slotRemoved(entry);
            if (shrink) {
                this.shrink();
            }
        } else {
            throw new AssertionError();
        }
    }

    protected V getAtTableOffset(int offset) {
        IntBuffer entry = ((IntBuffer)this.hashtable.duplicate().position(offset).limit(offset + 4)).slice();
        if (OffHeapHashMap.isPresent(entry)) {
            return this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
        }
        throw new AssertionError();
    }

    protected Map.Entry<K, V> getEntryAtTableOffset(int offset) {
        IntBuffer entry = ((IntBuffer)this.hashtable.duplicate().position(offset).limit(offset + 4)).slice();
        if (OffHeapHashMap.isPresent(entry)) {
            return new DirectEntry(entry);
        }
        throw new AssertionError();
    }

    @Override
    public Integer getSlotForHashAndEncoding(int hash, long encoding, long mask) {
        IntBuffer view = (IntBuffer)this.hashtable.duplicate().position(this.indexFor(OffHeapHashMap.spread(hash)));
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!view.hasRemaining()) {
                view.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)view.slice().limit(4))) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && hash == entry.get(1) && (encoding & mask) == (OffHeapHashMap.readLong(entry, 2) & mask)) {
                return view.position();
            }
            view.position(view.position() + 4);
        }
        return null;
    }

    @Override
    public boolean updateEncoding(int hash, long oldEncoding, long newEncoding, long mask) {
        boolean updated = OffHeapHashMap.updateEncodingInTable(this.hashtable, this.reprobeLimit(), hash, oldEncoding, newEncoding, mask);
        if (this.hasUsedIterators) {
            this.pendingTableFrees.reap();
            Iterator<PendingPage> it = this.pendingTableFrees.values();
            while (it.hasNext()) {
                PendingPage pending = it.next();
                updated |= OffHeapHashMap.updateEncodingInTable(pending.tablePage.asIntBuffer(), pending.reprobe, hash, oldEncoding, newEncoding, mask);
            }
        }
        return updated;
    }

    private static boolean updateEncodingInTable(IntBuffer table, int limit, int hash, long oldEncoding, long newEncoding, long mask) {
        table.position(OffHeapHashMap.indexFor(OffHeapHashMap.spread(hash), table));
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!table.hasRemaining()) {
                table.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)table.slice().limit(4))) {
                return false;
            }
            if (OffHeapHashMap.isPresent(entry) && hash == entry.get(1) && (oldEncoding & mask) == (OffHeapHashMap.readLong(entry, 2) & mask)) {
                entry.put(OffHeapHashMap.createEntry(hash, OffHeapHashMap.readLong(entry, 2) & (mask ^ 0xFFFFFFFFFFFFFFFFL) | newEncoding & mask, entry.get(0)));
                return true;
            }
            table.position(table.position() + 4);
        }
        return false;
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void slotRemoved(IntBuffer entry) {
        ++this.modCount;
        ++this.removedSlots;
        --this.size;
        this.updatePendingTables(entry.get(1), OffHeapHashMap.readLong(entry, 2), entry);
        this.removed(entry);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void slotAdded(IntBuffer entry) {
        ++this.modCount;
        ++this.size;
        this.added(entry);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void slotUpdated(IntBuffer entry, long oldEncoding) {
        ++this.modCount;
        this.updatePendingTables(entry.get(1), oldEncoding, entry);
        this.updated(entry);
    }

    protected void added(IntBuffer entry) {
    }

    protected void hit(IntBuffer entry) {
    }

    protected void removed(IntBuffer entry) {
    }

    protected void updated(IntBuffer entry) {
    }

    protected void tableExpansionFailure(int start, int length) {
        String msg = "Failed to expand table.\nCurrent Table Size (slots) : " + this.getTableCapacity() + '\n' + "Resize Will Require        : " + DebuggingUtils.toBase2SuffixedString(this.getTableCapacity() * 4L * 4L * 2L) + "B\nTable Buffer Source        : " + this.tableSource;
        throw new OversizeMappingException(msg);
    }

    protected void storageEngineFailure(Object failure) {
        String msg = "Storage engine failed to store: " + failure + '\n' + "StorageEngine: " + this.storageEngine;
        throw new OversizeMappingException(msg);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getTableCapacity() {
        IntBuffer table = this.hashtable;
        return table == null ? 0L : (long)(table.capacity() / 4);
    }

    @Override
    public long getUsedSlotCount() {
        return this.getSize();
    }

    @Override
    public long getRemovedSlotCount() {
        return this.removedSlots;
    }

    @Override
    public int getReprobeLength() {
        return this.reprobeLimit();
    }

    @Override
    public long getAllocatedMemory() {
        return this.getDataAllocatedMemory() + this.getTableCapacity() * 4L * 4L;
    }

    @Override
    public long getOccupiedMemory() {
        return this.getDataOccupiedMemory() + this.getUsedSlotCount() * 4L * 4L;
    }

    @Override
    public long getVitalMemory() {
        return this.getDataVitalMemory() + this.getTableCapacity() * 4L * 4L;
    }

    @Override
    public long getDataAllocatedMemory() {
        return this.storageEngine.getAllocatedMemory();
    }

    @Override
    public long getDataOccupiedMemory() {
        return this.storageEngine.getOccupiedMemory();
    }

    @Override
    public long getDataVitalMemory() {
        return this.storageEngine.getVitalMemory();
    }

    @Override
    public long getDataSize() {
        return this.storageEngine.getDataSize();
    }

    @Override
    public boolean isThiefForTableAllocations() {
        return this.tableAllocationsSteal;
    }

    @Override
    public Lock readLock() {
        return NoOpLock.INSTANCE;
    }

    @Override
    public Lock writeLock() {
        return NoOpLock.INSTANCE;
    }

    public StorageEngine<? super K, ? super V> getStorageEngine() {
        return this.storageEngine;
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public MetadataTuple<V> computeWithMetadata(K key, BiFunction<? super K, ? super MetadataTuple<V>, ? extends MetadataTuple<V>> remappingFunction) {
        this.freePendingTables();
        int hash = key.hashCode();
        IntBuffer originalTable = this.hashtable;
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                IntBuffer laterEntry = entry;
                while (i < limit && !OffHeapHashMap.isTerminating(laterEntry)) {
                    if (OffHeapHashMap.isPresent(laterEntry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1))) {
                        long encoding = OffHeapHashMap.readLong(laterEntry, 2);
                        MetadataTuple<V> existingValue = MetadataTuple.metadataTuple(this.storageEngine.readValue(encoding), laterEntry.get(0) & 0xFFFFFFFC);
                        MetadataTuple<V> result = remappingFunction.apply(key, existingValue);
                        if (result == null) {
                            this.storageEngine.freeMapping(OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1), true);
                            laterEntry.put(0, 2);
                            this.slotRemoved(laterEntry);
                            this.shrink();
                        } else if (result != existingValue) {
                            if (result.value() == existingValue.value()) {
                                int previous = laterEntry.get(0);
                                laterEntry.put(0, previous & 3 | result.metadata() & 0xFFFFFFFC);
                            } else {
                                int[] newEntry = this.writeEntry(key, hash, result.value(), result.metadata());
                                if (this.hashtable != originalTable || !OffHeapHashMap.isPresent(laterEntry)) {
                                    this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
                                    return this.computeWithMetadata(key, remappingFunction);
                                }
                                this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, result.metadata());
                                this.storageEngine.invalidateCache();
                                this.storageEngine.freeMapping(OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1), false);
                                long oldEncoding = OffHeapHashMap.readLong(laterEntry, 2);
                                laterEntry.put(newEntry);
                                this.slotUpdated((IntBuffer)laterEntry.flip(), oldEncoding);
                                this.hit(laterEntry);
                            }
                        }
                        return result;
                    }
                    this.hashtable.position(this.hashtable.position() + 4);
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    laterEntry = (IntBuffer)this.hashtable.slice().limit(4);
                    ++i;
                }
                MetadataTuple<V> result = remappingFunction.apply(key, null);
                if (result != null) {
                    int[] newEntry = this.writeEntry(key, hash, result.value(), result.metadata());
                    if (this.hashtable != originalTable) {
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
                        return this.computeWithMetadata(key, remappingFunction);
                    }
                    if (!OffHeapHashMap.isAvailable(entry)) {
                        throw new AssertionError();
                    }
                    if (OffHeapHashMap.isRemoved(entry)) {
                        --this.removedSlots;
                    }
                    this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, result.metadata());
                    this.storageEngine.invalidateCache();
                    entry.put(newEntry);
                    this.slotAdded(entry);
                    this.hit(entry);
                }
                return result;
            }
            if (this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                long existingEncoding = OffHeapHashMap.readLong(entry, 2);
                int existingStatus = entry.get(0);
                MetadataTuple<V> existingTuple = MetadataTuple.metadataTuple(this.storageEngine.readValue(existingEncoding), existingStatus & 0xFFFFFFFC);
                MetadataTuple<V> result = remappingFunction.apply(key, existingTuple);
                if (result == null) {
                    this.storageEngine.freeMapping(existingEncoding, hash, true);
                    entry.put(0, 2);
                    this.slotRemoved(entry);
                    this.shrink();
                } else if (result != existingTuple) {
                    if (result.value() == existingTuple.value()) {
                        entry.put(0, existingStatus & 3 | result.metadata() & 0xFFFFFFFC);
                    } else {
                        int[] newEntry = this.writeEntry(key, hash, result.value(), result.metadata());
                        if (this.hashtable != originalTable || !OffHeapHashMap.isPresent(entry)) {
                            this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
                            return this.computeWithMetadata(key, remappingFunction);
                        }
                        this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, result.metadata());
                        this.storageEngine.invalidateCache();
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), false);
                        entry.put(newEntry);
                        this.slotUpdated((IntBuffer)entry.flip(), existingEncoding);
                        this.hit(entry);
                    }
                }
                return result;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.expand(start, limit);
        return this.computeWithMetadata(key, remappingFunction);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public MetadataTuple<V> computeIfAbsentWithMetadata(K key, Function<? super K, ? extends MetadataTuple<V>> mappingFunction) {
        this.freePendingTables();
        int hash = key.hashCode();
        IntBuffer originalTable = this.hashtable;
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isAvailable(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                IntBuffer laterEntry = entry;
                while (i < limit && !OffHeapHashMap.isTerminating(laterEntry)) {
                    if (OffHeapHashMap.isPresent(laterEntry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(laterEntry, 2), laterEntry.get(1))) {
                        MetadataTuple<V> tuple = MetadataTuple.metadataTuple(this.storageEngine.readValue(OffHeapHashMap.readLong(laterEntry, 2)), laterEntry.get(0) & 0xFFFFFFFC);
                        return tuple;
                    }
                    this.hashtable.position(this.hashtable.position() + 4);
                    if (!this.hashtable.hasRemaining()) {
                        this.hashtable.rewind();
                    }
                    laterEntry = (IntBuffer)this.hashtable.slice().limit(4);
                    ++i;
                }
                MetadataTuple<V> result = mappingFunction.apply(key);
                if (result != null) {
                    int[] newEntry = this.writeEntry(key, hash, result.value(), result.metadata());
                    if (this.hashtable != originalTable) {
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
                        return this.computeIfAbsentWithMetadata(key, mappingFunction);
                    }
                    if (!OffHeapHashMap.isAvailable(entry)) {
                        throw new AssertionError();
                    }
                    if (OffHeapHashMap.isRemoved(entry)) {
                        --this.removedSlots;
                    }
                    this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, result.metadata());
                    this.storageEngine.invalidateCache();
                    entry.put(newEntry);
                    this.slotAdded(entry);
                    this.hit(entry);
                }
                return result;
            }
            if (this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                MetadataTuple<V> tuple = MetadataTuple.metadataTuple(this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2)), entry.get(0) & 0xFFFFFFFC);
                return tuple;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        this.expand(start, limit);
        return this.computeIfAbsentWithMetadata(key, mappingFunction);
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public MetadataTuple<V> computeIfPresentWithMetadata(K key, BiFunction<? super K, ? super MetadataTuple<V>, ? extends MetadataTuple<V>> remappingFunction) {
        this.freePendingTables();
        int hash = key.hashCode();
        IntBuffer originalTable = this.hashtable;
        int start = this.indexFor(OffHeapHashMap.spread(hash));
        this.hashtable.position(start);
        int limit = this.reprobeLimit();
        for (int i = 0; i < limit; ++i) {
            IntBuffer entry;
            if (!this.hashtable.hasRemaining()) {
                this.hashtable.rewind();
            }
            if (OffHeapHashMap.isTerminating(entry = (IntBuffer)this.hashtable.slice().limit(4))) {
                return null;
            }
            if (OffHeapHashMap.isPresent(entry) && this.keyEquals(key, hash, OffHeapHashMap.readLong(entry, 2), entry.get(1))) {
                long existingEncoding = OffHeapHashMap.readLong(entry, 2);
                int existingStatus = entry.get(0);
                MetadataTuple<V> existingValue = MetadataTuple.metadataTuple(this.storageEngine.readValue(existingEncoding), existingStatus & 0xFFFFFFFC);
                MetadataTuple<V> result = remappingFunction.apply(key, existingValue);
                if (result == null) {
                    this.storageEngine.freeMapping(existingEncoding, hash, true);
                    entry.put(0, 2);
                    this.slotRemoved(entry);
                    this.shrink();
                } else if (result != existingValue) {
                    if (result.value() == existingValue.value()) {
                        entry.put(0, existingStatus & 3 | result.metadata() & 0xFFFFFFFC);
                    } else {
                        int[] newEntry = this.writeEntry(key, hash, result.value(), result.metadata());
                        if (this.hashtable != originalTable || !OffHeapHashMap.isPresent(entry)) {
                            this.storageEngine.freeMapping(OffHeapHashMap.readLong(newEntry, 2), newEntry[1], false);
                            return this.computeIfPresentWithMetadata(key, remappingFunction);
                        }
                        this.storageEngine.attachedMapping(OffHeapHashMap.readLong(newEntry, 2), hash, result.metadata());
                        this.storageEngine.invalidateCache();
                        this.storageEngine.freeMapping(OffHeapHashMap.readLong(entry, 2), entry.get(1), false);
                        entry.put(newEntry);
                        this.slotUpdated((IntBuffer)entry.flip(), OffHeapHashMap.readLong(entry, 2));
                        this.hit(entry);
                    }
                }
                return result;
            }
            this.hashtable.position(this.hashtable.position() + 4);
        }
        return null;
    }

    class DirectEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        DirectEntry(IntBuffer entry) {
            this.key = OffHeapHashMap.this.storageEngine.readKey(OffHeapHashMap.readLong(entry, 2), entry.get(1));
            this.value = OffHeapHashMap.this.storageEngine.readValue(OffHeapHashMap.readLong(entry, 2));
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class EncodingIterator
    extends HashIterator<Long> {
        EncodingIterator() {
        }

        @Override
        protected Long create(IntBuffer entry) {
            return OffHeapHashMap.readLong(entry, 2);
        }
    }

    class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        protected Map.Entry<K, V> create(IntBuffer entry) {
            return new DirectEntry(entry);
        }
    }

    class KeyIterator
    extends HashIterator<K> {
        KeyIterator() {
        }

        @Override
        protected K create(IntBuffer entry) {
            return OffHeapHashMap.this.storageEngine.readKey(OffHeapHashMap.readLong(entry, 2), entry.get(1));
        }
    }

    static class PendingPage {
        final Page tablePage;
        final int reprobe;

        PendingPage(Page tablePage, int reprobe) {
            this.tablePage = tablePage;
            this.reprobe = reprobe;
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        final int expectedModCount;
        final IntBuffer table;
        final IntBuffer tableView;
        T next = null;

        HashIterator() {
            OffHeapHashMap.this.hasUsedIterators = true;
            this.table = OffHeapHashMap.this.hashtable;
            this.tableView = (IntBuffer)this.table.asReadOnlyBuffer().clear();
            this.expectedModCount = OffHeapHashMap.this.modCount;
            if (OffHeapHashMap.this.size > 0) {
                while (this.tableView.hasRemaining()) {
                    IntBuffer entry = (IntBuffer)this.tableView.slice().limit(4);
                    this.tableView.position(this.tableView.position() + 4);
                    if (!OffHeapHashMap.isPresent(entry)) continue;
                    this.next = this.create(entry);
                    break;
                }
            }
        }

        protected abstract T create(IntBuffer var1);

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            T e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            while (this.tableView.hasRemaining()) {
                IntBuffer entry = (IntBuffer)this.tableView.slice().limit(4);
                this.tableView.position(this.tableView.position() + 4);
                if (!OffHeapHashMap.isPresent(entry)) continue;
                this.next = this.create(entry);
                break;
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void checkForConcurrentModification() {
            if (OffHeapHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return OffHeapHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return OffHeapHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return OffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            OffHeapHashMap.this.clear();
        }
    }

    class EncodingSet
    extends AbstractSet<Long> {
        EncodingSet() {
        }

        @Override
        public Iterator<Long> iterator() {
            return new EncodingIterator();
        }

        @Override
        public int size() {
            return OffHeapHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = OffHeapHashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            return OffHeapHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return OffHeapHashMap.this.size;
        }

        @Override
        public void clear() {
            OffHeapHashMap.this.clear();
        }
    }
}

