/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules;

import java.net.URL;
import java.util.Properties;
import org.terracotta.modules.PropertiesLoadException;
import org.terracotta.modules.TimInfo;

public class BasicTimInfo
implements TimInfo {
    private final String groupId;
    private final String artifactId;
    private Properties props;

    public BasicTimInfo(String artifactId) {
        this("org.terracotta.modules", artifactId);
    }

    public BasicTimInfo(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String fullName() {
        return this.groupId() + "." + this.artifactId();
    }

    public synchronized Properties properties() {
        if (this.props == null) {
            this.props = new Properties();
            String propsPath = this.propertiesPath();
            URL propsUrl = this.getClass().getResource(propsPath);
            if (propsUrl == null) {
                throw new PropertiesLoadException("Error loading properties for TIM " + this.fullName() + ".  " + propsPath + " not found in CLASSPATH");
            }
            try {
                this.props.load(this.getClass().getResourceAsStream(propsPath));
            }
            catch (Exception e) {
                String message = "Error loading properties for TIM " + this.fullName();
                throw new PropertiesLoadException(message, e);
            }
        }
        return this.props;
    }

    protected String propertiesPath() {
        return '/' + this.groupId().replace('.', '/') + '/' + this.artifactId() + ".properties";
    }

    public String version() {
        return this.properties().getProperty("version");
    }
}

