/* $Id: TimInfo.java 12348 2008-12-09 23:39:43Z sbale $
 * Copyright (c) 2003-2008 Terracotta, Inc. All rights reserved.
 */
package org.terracotta.modules;

import java.util.Properties;

/**
 * Provides information about a Terracotta Integration module, including
 * groupId, artifactId, and version.
 *
 * @author Jason Voegele (jvoegele@terracotta.org)
 */
public interface TimInfo {
  
  interface TimInfoFactory{
    TimInfo create(String artifactId);
    TimInfo create(String groupId, String artifactId);
  }
  
  static final TimInfoFactory FACTORY = new TimInfoFactory(){

    public TimInfo create(String artifactId) {
      return create(DEFAULT_GROUP_ID, artifactId);
    }

    public TimInfo create(String groupId, String artifactId) {
      return new BasicTimInfo(groupId, artifactId);
    }
  };
  
  /** Default value for groupId. */
  public static final String DEFAULT_GROUP_ID = "org.terracotta.modules";

  /**
   * Returns the groupId for the TIM.
   */
  String groupId();

  /**
   * Returns the artifactId for the TIM.
   */
  String artifactId();

  /**
   * Returns the full name of the TIM.  The full name is the concatenation of
   * the groupId and the artifactId, with an intervening '.' character.
   */
  String fullName();

  /**
   * Returns the version of the TIM.
   */
  String version();

  /**
   * Returns the properties associated with the TIM.
   */
  Properties properties();
}
