/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.workmanager.support;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.workmanager.support.DefaultWorkEvent;

public class DefaultWorkItem
implements WorkItem {
    private static final transient Logger logger = LoggerFactory.getLogger(DefaultWorkItem.class);
    public static final int NO_STATUS_TRACKING = -1;
    private int status = -1;
    private final Work work;
    private final WorkListener workListener;
    private final boolean cancelWorkStatusTracking;

    public DefaultWorkItem(Work work, WorkListener workListener, boolean cancelWorkStatusTracking) {
        this.work = work;
        this.workListener = workListener;
        this.cancelWorkStatusTracking = cancelWorkStatusTracking;
    }

    public synchronized Work getResult() {
        return this.work;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized void setStatus(int status, WorkException exception) {
        if (!this.cancelWorkStatusTracking) {
            this.status = status;
            if (this.workListener != null) {
                switch (status) {
                    case 1: {
                        this.workListener.workAccepted((WorkEvent)new DefaultWorkEvent(1, this, exception));
                        break;
                    }
                    case 2: {
                        this.workListener.workRejected((WorkEvent)new DefaultWorkEvent(2, this, exception));
                        break;
                    }
                    case 3: {
                        this.workListener.workStarted((WorkEvent)new DefaultWorkEvent(3, this, exception));
                        break;
                    }
                    case 4: {
                        this.workListener.workCompleted((WorkEvent)new DefaultWorkEvent(4, this, exception));
                    }
                }
            }
        } else {
            logger.warn("Setting status on a work item with disabled status tracking: this will have no effect.");
        }
    }

    public int compareTo(Object compareTo) {
        Work otherWork = ((WorkItem)compareTo).getResult();
        if (otherWork instanceof Comparable) {
            Comparable comparableWork1 = (Comparable)otherWork;
            if (this.work instanceof Comparable) {
                Comparable comparableWork2 = (Comparable)this.work;
                return comparableWork2.compareTo(comparableWork1);
            }
        }
        return 0;
    }

    public String toString() {
        String out;
        switch (this.status) {
            case 1: {
                out = "WORK_ACCEPTED";
                break;
            }
            case 4: {
                out = "WORK_COMPLETED";
                break;
            }
            case 2: {
                out = "WORK_REJECTED";
                break;
            }
            case 3: {
                out = "WORK_STARTED";
                break;
            }
            default: {
                out = "UNKNOWN";
            }
        }
        return this.work.toString() + ":" + out;
    }
}

