/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.workmanager;

import commonj.work.WorkException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.AbstractWorker;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;
import org.terracotta.workmanager.support.DefaultWorkItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWorkManagerWorker
extends AbstractWorker<DefaultWorkItem> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractWorkManagerWorker.class);

    public AbstractWorkManagerWorker(String workerPrefix, String topologyName, ExecutorService executorService) {
        this(workerPrefix, topologyName, null, executorService);
    }

    public AbstractWorkManagerWorker(String workerPrefix, String topologyName, Topology.Factory topologyFactory, ExecutorService executorService) {
        super(workerPrefix, TopologyManager.getInstance().getOrCreateTopology(topologyName, topologyFactory), executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(WorkMessage<DefaultWorkItem> workMessage) {
        DefaultWorkItem workItem = workMessage.getWorkObject();
        try {
            workItem.setStatus(3, null);
            workItem.getResult().run();
            workItem.setStatus(4, null);
        }
        catch (Exception ex) {
            logger.error("Exception while running work!", (Throwable)ex);
            logger.error("Work will be rejected...");
            workItem.setStatus(2, new WorkException((Throwable)ex));
        }
        finally {
            logger.info("Work {} execution ended.", (Object)workItem);
            this.doReply(workMessage);
        }
    }
}

