/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.masterworker;

import com.tc.cluster.DsoClusterEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.Master;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.masterworker.cluster.ClusterState;
import org.terracotta.masterworker.cluster.ClusterStateEvent;
import org.terracotta.masterworker.cluster.ClusterStateListener;
import org.terracotta.message.pipe.Pipe;
import org.terracotta.message.pipe.PipeProcessor;
import org.terracotta.message.routing.Route;
import org.terracotta.message.routing.Router;
import org.terracotta.message.routing.RoutingFilter;
import org.terracotta.message.topology.Topology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMaster<T>
implements Master<T> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractMaster.class);
    private final ClusterState clusterState;
    private final ClusterStateListener masterClusterListener;
    private final String masterId = UUID.randomUUID().toString();
    private final Router router;
    private final Topology<WorkMessage<T>, String> topology;
    private final String replyPipeID;
    private final PipeProcessor<WorkMessage<T>> replyPipeProcessor;
    private final List<String> registeredRoutingIDs;
    private final RoutingFilter masterRoutingFilter;
    private volatile boolean started;
    private volatile boolean shutdown;
    private volatile int totalPending;

    public AbstractMaster(Topology<WorkMessage<T>, String> topology, Router router) {
        this.router = router;
        this.topology = topology;
        this.replyPipeID = this.masterId + "-replyPipe";
        this.replyPipeProcessor = new ReplyPipeListener(topology.getOrCreatePipeFor((Object)this.replyPipeID), this.replyPipeID);
        this.registeredRoutingIDs = new LinkedList<String>();
        this.masterRoutingFilter = new MasterRoutingFilter();
        this.clusterState = ClusterState.getOrCreateInstance(topology.getName());
        this.masterClusterListener = new MasterClusterListener();
    }

    @Override
    public final synchronized void start() {
        if (!this.started && !this.shutdown) {
            this.initClusterState();
            List<String> workers = this.clusterState.getAllWorkers();
            for (String worker : workers) {
                this.doRegister(worker);
            }
            this.replyPipeProcessor.start();
            this.started = true;
        }
    }

    @Override
    public final synchronized T submit(T work) {
        if (this.started && !this.shutdown) {
            this.doSubmit(work);
            return work;
        }
        return null;
    }

    @Override
    public final synchronized void register(String routingID) {
        if (this.started && !this.shutdown) {
            this.doRegister(routingID);
            this.flushUnsubmittedWorks();
        }
    }

    @Override
    public final synchronized void unregister(String routingID) {
        if (this.started && !this.shutdown) {
            this.doUnregister(routingID);
            this.reRoutePendingWorks(routingID);
        }
    }

    @Override
    public final synchronized void shutdown() {
        if (this.started && !this.shutdown) {
            this.started = false;
            this.shutdown = true;
            this.onShutdown();
            CleanupThread cleanupThread = new CleanupThread();
            cleanupThread.start();
        }
    }

    @Override
    public final synchronized List<T> shutdownNow() {
        if (this.started && !this.shutdown) {
            this.started = false;
            this.shutdown = true;
            LinkedList pendingWorks = new LinkedList();
            this.clusterState.copySubmittedPendingWorksForMasterTo(this.masterId, pendingWorks);
            this.clusterState.copyUnsubmittedPendingWorksForMasterTo(this.masterId, pendingWorks);
            this.onShutdown();
            this.cleanupNow();
            return pendingWorks;
        }
        return new ArrayList(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shutdown) {
            long startTime = 0L;
            AbstractMaster abstractMaster = this;
            synchronized (abstractMaster) {
                for (long waitingTime = TimeUnit.MILLISECONDS.convert(timeout, unit); this.totalPending > 0 && waitingTime > 0L; waitingTime -= System.currentTimeMillis() - startTime) {
                    startTime = System.currentTimeMillis();
                    logger.debug("Waiting {} millis for termination ...", (Object)waitingTime);
                    this.wait(waitingTime);
                }
                return this.totalPending == 0;
            }
        }
        return false;
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public final boolean isTerminated() {
        return this.shutdown && this.totalPending == 0;
    }

    protected void onComplete(WorkMessage<T> workMessage) {
    }

    protected void onShutdown() {
    }

    private void initClusterState() {
        this.clusterState.clearDisconnectedState();
        this.clusterState.addMasterForNode(this.masterId, this.clusterState.getCurrentNodeId());
        this.clusterState.registerClusterStateListener(this.masterClusterListener);
    }

    private void clearClusterState() {
        this.clusterState.unregisterClusterStateListener(this.masterClusterListener);
        this.clusterState.removeMasterForNode(this.masterId, this.clusterState.getCurrentNodeId());
    }

    private void doSubmit(T work) {
        Route route = this.topology.getRouteFor(this.router, this.masterRoutingFilter, work);
        if (route != null) {
            String workPipeID;
            WorkMessage<T> workMessage;
            Pipe workPipe = route.getPipe();
            boolean submitted = workPipe.offer(workMessage = new WorkMessage<T>(work, workPipeID = (String)route.getRoutingID(), this.replyPipeID));
            if (submitted) {
                logger.debug("Submitted work {} on pipe {}", work, (Object)workPipeID);
                this.addToSubmittedPendingWorks(workPipeID, work);
            } else {
                logger.debug("Scheduled work {} for later submission (apparently full queue).", work);
                this.addToUnsubmittedPendingWorks(work);
            }
        } else {
            logger.debug("Scheduled work {} for later submission (apparently no route).", work);
            this.addToUnsubmittedPendingWorks(work);
        }
        logger.debug("There are {} total pending works", (Object)this.totalPending);
    }

    private void doRegister(String routingID) {
        if (!this.registeredRoutingIDs.contains(routingID)) {
            logger.info("Registering pipe for {}", (Object)routingID);
            this.registeredRoutingIDs.add(routingID);
        }
    }

    private void doUnregister(String routingID) {
        if (this.registeredRoutingIDs.contains(routingID)) {
            logger.info("Unregistering pipe for {}", (Object)routingID);
            this.registeredRoutingIDs.remove(routingID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRoutePendingWorks(String routingID) {
        try {
            Map<String, Queue> submittedPendingWorks = this.clusterState.acquireSubmittedPendingWorksForMaster(this.masterId);
            Queue pendingQueue = submittedPendingWorks.get(routingID);
            if (pendingQueue != null && !pendingQueue.isEmpty()) {
                logger.info("Rerouting {} pending works for {}", (Object)pendingQueue.size(), (Object)routingID);
                int pendings = pendingQueue.size();
                for (int i = 0; i < pendings; ++i) {
                    Object work = pendingQueue.poll();
                    --this.totalPending;
                    this.doSubmit(work);
                }
            }
        }
        finally {
            this.clusterState.releaseSubmittedPendingWorksForMaster(this.masterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSubmittedPendingWorks(String routingID, T work) {
        try {
            Map<String, Queue> submittedPendingWorks = this.clusterState.acquireSubmittedPendingWorksForMaster(this.masterId);
            LinkedList<T> pendingQueue = submittedPendingWorks.get(routingID);
            if (pendingQueue == null) {
                pendingQueue = new LinkedList<T>();
                submittedPendingWorks.put(routingID, pendingQueue);
            }
            pendingQueue.offer(work);
            ++this.totalPending;
            logger.debug("There are {} submitted pending works", (Object)pendingQueue.size());
        }
        finally {
            this.clusterState.releaseSubmittedPendingWorksForMaster(this.masterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromSubmittedPendingWorks(String routingID, T work) {
        try {
            Map<String, Queue> submittedPendingWorks = this.clusterState.acquireSubmittedPendingWorksForMaster(this.masterId);
            Queue pendingQueue = submittedPendingWorks.get(routingID);
            if (pendingQueue != null) {
                pendingQueue.remove(work);
                --this.totalPending;
                logger.debug("There are {} submitted pending works", (Object)pendingQueue.size());
                this.notifyAll();
            }
        }
        finally {
            this.clusterState.releaseSubmittedPendingWorksForMaster(this.masterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUnsubmittedPendingWorks(T work) {
        try {
            Queue unsubmittedPendingWorks = this.clusterState.acquireUnsubmittedPendingWorksForMaster(this.masterId);
            unsubmittedPendingWorks.offer(work);
            ++this.totalPending;
            logger.debug("There are {} unsubmitted pending works", (Object)unsubmittedPendingWorks.size());
        }
        finally {
            this.clusterState.releaseUnsubmittedPendingWorksForMaster(this.masterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUnsubmittedWorks() {
        try {
            Queue unsubmittedPendingWorks = this.clusterState.acquireUnsubmittedPendingWorksForMaster(this.masterId);
            int unsubmitteds = unsubmittedPendingWorks.size();
            for (int i = 0; i < unsubmitteds; ++i) {
                Object work = unsubmittedPendingWorks.peek();
                if (work != null) {
                    unsubmittedPendingWorks.remove(work);
                    --this.totalPending;
                } else {
                    throw new IllegalStateException();
                }
                logger.debug("Flushing, there are still {} unsubmitted pending works", (Object)unsubmittedPendingWorks.size());
                this.doSubmit(work);
            }
        }
        finally {
            this.clusterState.releaseUnsubmittedPendingWorksForMaster(this.masterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAndCleanup() throws InterruptedException {
        AbstractMaster abstractMaster = this;
        synchronized (abstractMaster) {
            while (this.totalPending > 0) {
                this.wait();
            }
        }
        this.replyPipeProcessor.stop();
        this.topology.removePipeFor((Object)this.replyPipeID);
        this.clearClusterState();
    }

    private void cleanupNow() {
        this.replyPipeProcessor.stop();
        this.topology.removePipeFor((Object)this.replyPipeID);
        this.clearClusterState();
    }

    private class CleanupThread
    extends Thread {
        private CleanupThread() {
        }

        public void run() {
            try {
                AbstractMaster.this.waitAndCleanup();
            }
            catch (InterruptedException ex) {
                logger.warn("Error executing master termination: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplyPipeListener
    extends PipeProcessor<WorkMessage<T>> {
        private final String replyPipeID;

        public ReplyPipeListener(Pipe<WorkMessage<T>> replyPipe, String replyPipeID) {
            super(replyPipe, true);
            this.replyPipeID = replyPipeID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean event(WorkMessage<T> workMessage) throws Exception {
            AbstractMaster abstractMaster = AbstractMaster.this;
            synchronized (abstractMaster) {
                AbstractMaster.this.onComplete(workMessage);
                AbstractMaster.this.removeFromSubmittedPendingWorks(workMessage.getWorkPipeRoutingID(), workMessage.getWorkObject());
                AbstractMaster.this.flushUnsubmittedWorks();
            }
            return true;
        }
    }

    private class MasterClusterListener
    implements ClusterStateListener {
        private final Lock singleResourceLock = new ReentrantLock();

        private MasterClusterListener() {
        }

        public void workerAdded(ClusterStateEvent event) {
            AbstractMaster.this.register(event.getWorker());
        }

        public void workerRemoved(ClusterStateEvent event) {
            AbstractMaster.this.unregister(event.getWorker());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeLeft(DsoClusterEvent event) {
            String nodeLeftId = event.getNode().getId();
            logger.info("Node left: {}", (Object)nodeLeftId);
            try {
                List<String> workers;
                this.singleResourceLock.lock();
                List<String> masters = AbstractMaster.this.clusterState.getMastersForNode(nodeLeftId);
                if (!masters.isEmpty()) {
                    for (String masterId : masters) {
                        logger.info("Resubmitting works for master: {}", (Object)masterId);
                        this.resubmitForMaster(masterId);
                        AbstractMaster.this.clusterState.removeMasterForNode(masterId, nodeLeftId);
                    }
                }
                if (!(workers = AbstractMaster.this.clusterState.getWorkersForNode(nodeLeftId)).isEmpty()) {
                    for (String workerId : workers) {
                        AbstractMaster.this.clusterState.removeWorkerForNode(workerId, nodeLeftId);
                    }
                }
            }
            finally {
                this.singleResourceLock.unlock();
            }
        }

        public void masteAdded(ClusterStateEvent event) {
        }

        public void masterRemoved(ClusterStateEvent event) {
        }

        public void nodeJoined(DsoClusterEvent event) {
        }

        public void operationsEnabled(DsoClusterEvent event) {
        }

        public void operationsDisabled(DsoClusterEvent event) {
        }

        private void resubmitForMaster(String masterId) {
            LinkedList pendingWorks = new LinkedList();
            AbstractMaster.this.clusterState.copySubmittedPendingWorksForMasterTo(masterId, pendingWorks);
            AbstractMaster.this.clusterState.copyUnsubmittedPendingWorksForMasterTo(masterId, pendingWorks);
            logger.info("Works to resubmit: {}", (Object)pendingWorks.size());
            for (Object work : pendingWorks) {
                AbstractMaster.this.submit(work);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterRoutingFilter
    implements RoutingFilter {
        private MasterRoutingFilter() {
        }

        public <V, ID> boolean accept(Pipe<V> pipe, ID routingID) {
            return AbstractMaster.this.registeredRoutingIDs.contains(routingID);
        }
    }
}

