/**
 * 
 * All content copyright (c) 2003-2008 Terracotta, Inc.,
 * except as may otherwise be noted in a separate copyright notice.
 * All rights reserved.
 *
 */
package org.terracotta.workmanager.support;

import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkItem;

/**
 * {@link commonj.work.WorkEvent} implementation, sent to registered {@link commonj.work.WorkListener}s on work status changing.
 */
public class DefaultWorkEvent implements WorkEvent {

    private final int type;
    private final WorkItem workItem;
    private final WorkException exception;

    public DefaultWorkEvent(final int type, final WorkItem item, final WorkException exception) {
        this.type = type;
        this.workItem = item;
        this.exception = exception;
    }

    public int getType() {
        return type;
    }

    public WorkItem getWorkItem() {
        return workItem;
    }

    public WorkException getException() {
        return exception;
    }
}
