/**
 * 
 * All content copyright (c) 2003-2008 Terracotta, Inc.,
 * except as may otherwise be noted in a separate copyright notice.
 * All rights reserved.
 *
 */
package org.terracotta.workmanager;

import org.terracotta.message.routing.Router;
import org.terracotta.message.topology.Topology;

/**
 * Distributed WorkManager implementation with submitted works executed by running {@link org.terracotta.workmanager.DistributedWorker} instances.
 */
public class DistributedWorkManager extends AbstractWorkManager {

    /**
     * Create a DistributedWorkManager.
     * 
     * @param topology The name of the topology backing this work manager: the actual {@link org.terracotta.message.topology.Topology}
     * implementation is left to the work manager.
     * @param router The {@link org.terracotta.message.routing.Router} to use for routing scheduled works.
     */
    public DistributedWorkManager(final String topology, final Router router) {
        super(topology, router);
    }

    /**
     * Create a DistributedWorkManager.
     * 
     * @param topology The name of the topology backing this work manager.
     * @param topologyFactory The factory to use for the topology implementation.
     * @param router The {@link org.terracotta.message.routing.Router} to use for routing scheduled works.
     */
    public DistributedWorkManager(final String topology, final Topology.Factory topologyFactory, final Router router) {
        super(topology, topologyFactory, router);
    }
}
