/**
 *
 * All content copyright (c) 2003-2008 Terracotta, Inc.,
 * except as may otherwise be noted in a separate copyright notice.
 * All rights reserved.
 *
 */
package org.terracotta.workmanager;

import commonj.work.WorkEvent;
import commonj.work.WorkException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.AbstractWorker;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;
import org.terracotta.workmanager.support.DefaultWorkItem;

/**
 * Abstract worker implementation based on {@link org.terracotta.masterworker.AbstractWorker}
 * and {@link DefaultWorkItem}.
 */
public class AbstractWorkManagerWorker extends AbstractWorker<DefaultWorkItem> {

    private transient static final Logger logger = LoggerFactory.getLogger(AbstractWorkManagerWorker.class);

    public AbstractWorkManagerWorker(final String workerPrefix, final String topologyName, final ExecutorService executorService) {
        this(workerPrefix, topologyName, null, executorService);
    }

    public AbstractWorkManagerWorker(final String workerPrefix, final String topologyName, final Topology.Factory topologyFactory, final ExecutorService executorService) {
        super(workerPrefix, TopologyManager.getInstance().<WorkMessage<DefaultWorkItem>, String>getOrCreateTopology(topologyName, topologyFactory), executorService);
    }

    @Override
    protected void doExecute(final WorkMessage<DefaultWorkItem> workMessage) {
        DefaultWorkItem workItem = workMessage.getWorkObject();
        try {
            workItem.setStatus(WorkEvent.WORK_STARTED, null);
            workItem.getResult().run();
            workItem.setStatus(WorkEvent.WORK_COMPLETED, null);
        } catch (Exception ex) {
            logger.error("Exception while running work!", ex);
            logger.error("Work will be rejected...");
            workItem.setStatus(WorkEvent.WORK_REJECTED, new WorkException(ex));
        } finally {
            logger.info("Work {} execution ended.", workItem);
            doReply(workMessage);
        }
    }
}
