/**
 * 
 * All content copyright (c) 2003-2008 Terracotta, Inc.,
 * except as may otherwise be noted in a separate copyright notice.
 * All rights reserved.
 *
 */
package org.terracotta.masterworker;

/**
 * Wrapper for work objects defining information about the message.
 * 
 * @param <T> Type of the work object to wrap.
 */
public class WorkMessage<T> {
    
    private final T workObject;
    private final String workPipeRoutingID;
    private final String replyPipeRoutingID;

    /**
     * @param workObject The work object wrapped by this message.
     * @param workPipeRoutingID The routing identifier of the pipe which the wrapped work has been routed to.
     * @param replyPipeRoutingID The routing identifier of the pipe to use for replying to this work.
     */
    public WorkMessage(T workObject, String workPipeRoutingID, String replyPipeRoutingID) {
        this.workObject = workObject;
        this.workPipeRoutingID = workPipeRoutingID;
        this.replyPipeRoutingID = replyPipeRoutingID;
    }

    /**
     * Ghe work object wrapped by this message.
     * @return
     */
    public T getWorkObject() {
        return workObject;
    }
    
    /**
     * Get the routing identifier of the pipe which the wrapped work has been routed to.
     * @return
     */
    public String getWorkPipeRoutingID() {
        return workPipeRoutingID;
    }

    /**
     * Get the routing identifier of the pipe to use for replying to this work.
     * @return
     */
    public String getReplyPipeRoutingID() {
        return replyPipeRoutingID;
    }

    @Override
    public String toString() {
        return workObject.toString();
    }
}
