/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind.snapshots;

import java.io.IOException;
import net.sf.ehcache.Element;
import org.terracotta.annotations.InstrumentedClass;
import org.terracotta.cache.serialization.SerializationStrategy;

@InstrumentedClass
public abstract class ElementSnapshot {
    private final long version;
    private final long hitCount;
    private final int timeToLive;
    private final int timeToIdle;
    private final long creationTime;
    private final long lastAccessTime;
    private final long lastUpdateTime;

    public ElementSnapshot(Element element) {
        this.version = element.getVersion();
        this.hitCount = element.getHitCount();
        this.timeToLive = element.getTimeToLive();
        this.timeToIdle = element.getTimeToIdle();
        this.creationTime = element.getCreationTime();
        this.lastAccessTime = element.getLastAccessTime();
        this.lastUpdateTime = element.getLastUpdateTime();
    }

    public final Element createElement(SerializationStrategy strategy) throws ClassNotFoundException, IOException {
        return new Element(this.getKey(strategy), this.getValue(strategy), this.version, this.creationTime, this.lastAccessTime, this.hitCount, false, this.timeToLive, this.timeToIdle, this.lastUpdateTime);
    }

    public abstract Object getKey(SerializationStrategy var1) throws IOException, ClassNotFoundException;

    public abstract Object getValue(SerializationStrategy var1) throws IOException, ClassNotFoundException;
}

