/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.operations.SingleOperationType;
import org.terracotta.annotations.InstrumentedClass;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.modules.ehcache.writebehind.operations.BatchAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.SingleAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.WriteAllAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.snapshots.ElementSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InstrumentedClass
public class WriteAsyncOperation
implements SingleAsyncOperation {
    private final ElementSnapshot snapshot;
    private final long creationTime;

    public WriteAsyncOperation(ElementSnapshot snapshot) {
        this.snapshot = snapshot;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void performSingleOperation(CacheWriter cacheWriter, SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        cacheWriter.write(this.createElement(serializationStrategy));
    }

    public Element createElement(SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        return this.snapshot.createElement(serializationStrategy);
    }

    @Override
    public BatchAsyncOperation createBatchOperation(List<SingleAsyncOperation> operations, SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (SingleAsyncOperation operation : operations) {
            elements.add(((WriteAsyncOperation)operation).createElement(serializationStrategy));
        }
        return new WriteAllAsyncOperation(elements);
    }

    @Override
    public Object getKey(SerializationStrategy serializationStrategy) throws IOException, ClassNotFoundException {
        return this.snapshot.getKey(serializationStrategy);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void throwAwayElement(CacheWriter cacheWriter, SerializationStrategy serializationStrategy, RuntimeException e) throws ClassNotFoundException, IOException {
        cacheWriter.throwAway(this.createElement(serializationStrategy), SingleOperationType.WRITE, e);
    }
}

