/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.operations.SingleOperationType;
import org.terracotta.annotations.InstrumentedClass;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.modules.ehcache.writebehind.operations.BatchAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.DeleteAllAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.SingleAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.snapshots.ElementSnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.KeySnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InstrumentedClass
public class DeleteAsyncOperation
implements SingleAsyncOperation {
    private final KeySnapshot keySnapshot;
    private final ElementSnapshot elementSnapshot;
    private final long creationTime;

    public DeleteAsyncOperation(KeySnapshot keySnapshot, ElementSnapshot elementSnapshot) {
        this.keySnapshot = keySnapshot;
        this.elementSnapshot = elementSnapshot;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public void performSingleOperation(CacheWriter cacheWriter, SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        cacheWriter.delete(new CacheEntry(this.getKey(serializationStrategy), this.createElement(serializationStrategy)));
    }

    @Override
    public Object getKey(SerializationStrategy serializationStrategy) throws IOException, ClassNotFoundException {
        return this.keySnapshot.getKey(serializationStrategy);
    }

    public Element createElement(SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        if (null == this.elementSnapshot) {
            return null;
        }
        return this.elementSnapshot.createElement(serializationStrategy);
    }

    @Override
    public BatchAsyncOperation createBatchOperation(List<SingleAsyncOperation> operations, SerializationStrategy serializationStrategy) throws ClassNotFoundException, IOException {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
        for (SingleAsyncOperation operation : operations) {
            DeleteAsyncOperation deleteOperation = (DeleteAsyncOperation)operation;
            entries.add(new CacheEntry(deleteOperation.getKey(serializationStrategy), deleteOperation.createElement(serializationStrategy)));
        }
        return new DeleteAllAsyncOperation(entries);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void throwAwayElement(CacheWriter cacheWriter, SerializationStrategy serializationStrategy, RuntimeException e) throws ClassNotFoundException, IOException {
        cacheWriter.throwAway(this.createElement(serializationStrategy), SingleOperationType.DELETE, e);
    }
}

