/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.writer.CacheWriter;
import org.terracotta.async.ItemProcessor2;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.modules.ehcache.writebehind.operations.SingleAsyncOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWriterWrapper
implements ItemProcessor2<SingleAsyncOperation> {
    private final CacheWriter cacheWriter;
    private final SerializationStrategy serializationStrategy;

    public CacheWriterWrapper(CacheWriter cacheWriter, SerializationStrategy serializationStrategy) {
        this.cacheWriter = cacheWriter;
        this.serializationStrategy = serializationStrategy;
    }

    public void process(SingleAsyncOperation operation) {
        try {
            operation.performSingleOperation(this.cacheWriter, this.serializationStrategy);
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while processing write behind operation", (Throwable)e);
        }
    }

    public void process(Collection<SingleAsyncOperation> items) {
        HashMap separatedItemsPerType = new HashMap();
        for (SingleAsyncOperation item : items) {
            ArrayList<SingleAsyncOperation> itemsPerType = (ArrayList<SingleAsyncOperation>)separatedItemsPerType.get(item.getClass());
            if (null == itemsPerType) {
                itemsPerType = new ArrayList<SingleAsyncOperation>();
                separatedItemsPerType.put(item.getClass(), itemsPerType);
            }
            itemsPerType.add(item);
        }
        try {
            for (List itemsPerType : separatedItemsPerType.values()) {
                ((SingleAsyncOperation)itemsPerType.get(0)).createBatchOperation(itemsPerType, this.serializationStrategy).performBatchOperation(this.cacheWriter);
            }
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while processing write behind operation", (Throwable)e);
        }
    }

    public void throwAway(SingleAsyncOperation operation, RuntimeException runtimeException) {
        try {
            operation.throwAwayElement(this.cacheWriter, this.serializationStrategy, runtimeException);
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while throwing away write behind operation", (Throwable)e);
        }
    }
}

