/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.OperationsFilter;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import net.sf.ehcache.writer.writebehind.operations.KeyBasedOperation;
import org.terracotta.async.AsyncCoordinator;
import org.terracotta.async.ItemProcessor;
import org.terracotta.async.ItemScatterPolicy;
import org.terracotta.async.ProcessingBucket;
import org.terracotta.async.QuarantinedItemsFilter;
import org.terracotta.cache.serialization.DsoSerializationStrategy;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.modules.ehcache.writebehind.CacheWriterWrapper;
import org.terracotta.modules.ehcache.writebehind.OperationsFilterWrapper;
import org.terracotta.modules.ehcache.writebehind.operations.DeleteAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.SingleAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.WriteAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.snapshots.ElementSnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.IdentityElementSnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.IdentityKeySnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.KeySnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.SerializationElementSnapshot;
import org.terracotta.modules.ehcache.writebehind.snapshots.SerializationKeySnapshot;

public class AsyncWriteBehind
implements WriteBehind {
    private final AsyncCoordinator<SingleAsyncOperation> async;
    private final TerracottaConfiguration.ValueMode valueMode;
    private final SerializationStrategy serializationStrategy;
    private final int concurrency;
    private final Lock writeLock;
    private final Lock readLock;
    private volatile Status status = Status.UNINITIALIZED;

    public AsyncWriteBehind(AsyncCoordinator async, Ehcache cache, DsoSerializationStrategy serializationStrategy) {
        this.async = async;
        this.valueMode = cache.getCacheConfiguration().getTerracottaConfiguration().getValueMode();
        this.concurrency = cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteBehindConcurrency();
        this.serializationStrategy = serializationStrategy;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(CacheWriter writer) {
        this.writeLock.lock();
        try {
            this.status = Status.STARTED;
            this.async.start((ItemProcessor)new CacheWriterWrapper(writer, this.serializationStrategy), this.concurrency, (ItemScatterPolicy)new SingleAsyncOperationItemScatterPolicy(this.serializationStrategy));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Element element) {
        this.readLock.lock();
        try {
            this.status.checkRunning();
            ElementSnapshot snapshot = this.createElementSnapshot(element);
            this.async.add((Object)new WriteAsyncOperation(snapshot));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CacheEntry entry) {
        this.readLock.lock();
        try {
            this.status.checkRunning();
            this.async.add((Object)new DeleteAsyncOperation(this.createKeySnapshot(entry.getKey()), this.createElementSnapshot(entry.getElement())));
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOperationsFilter(OperationsFilter filter) {
        this.async.setQuarantinedItemsFilter((QuarantinedItemsFilter)new OperationsFilterWrapper((OperationsFilter<KeyBasedOperation>)filter, this.serializationStrategy));
    }

    private ElementSnapshot createElementSnapshot(Element element) {
        ElementSnapshot snapshot;
        if (null == element) {
            return null;
        }
        switch (this.valueMode) {
            case IDENTITY: {
                snapshot = new IdentityElementSnapshot(element);
                break;
            }
            case SERIALIZATION: {
                try {
                    snapshot = new SerializationElementSnapshot(this.serializationStrategy, element);
                    break;
                }
                catch (IOException e) {
                    throw new CacheException("Unexpected exception while creating a snapshot of element " + element, (Throwable)e);
                }
            }
            default: {
                throw new CacheException("Unsupported Terracotta value mode " + this.valueMode);
            }
        }
        return snapshot;
    }

    private KeySnapshot createKeySnapshot(Object key) {
        KeySnapshot snapshot;
        switch (this.valueMode) {
            case IDENTITY: {
                snapshot = new IdentityKeySnapshot(key);
                break;
            }
            case SERIALIZATION: {
                try {
                    snapshot = new SerializationKeySnapshot(this.serializationStrategy, key);
                    break;
                }
                catch (IOException e) {
                    throw new CacheException("Unexpected exception while creating a snapshot of key " + key, (Throwable)e);
                }
            }
            default: {
                throw new CacheException("Unsupported Terracotta value mode " + this.valueMode);
            }
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.writeLock.lock();
        try {
            this.async.stop();
            this.status = Status.STOPPED;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQueueSize() {
        this.readLock.lock();
        try {
            this.status.checkRunning();
            int size = 0;
            for (ProcessingBucket localBucket : this.async.getLocalBuckets()) {
                size += localBucket.getWaitCount();
            }
            long l = size;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        UNINITIALIZED,
        STARTED{

            final void checkRunning() {
            }
        }
        ,
        STOPPED;


        void checkRunning() {
            throw new IllegalStateException("AsyncWriteBehind is " + this.name().toLowerCase() + "!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleAsyncOperationItemScatterPolicy
    implements ItemScatterPolicy<SingleAsyncOperation> {
        private final SerializationStrategy serializationStrategy;

        private SingleAsyncOperationItemScatterPolicy(SerializationStrategy serializationStrategy) {
            this.serializationStrategy = serializationStrategy;
        }

        public int selectBucket(int count, SingleAsyncOperation item) {
            Object key;
            try {
                key = item.getKey(this.serializationStrategy);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            return Math.abs(key.hashCode() % count);
        }
    }
}

