/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.transaction.xa;

import javax.transaction.xa.Xid;
import net.sf.ehcache.transaction.xa.XidTransactionID;
import org.terracotta.modules.ehcache.transaction.xa.XidClustered;

public class ClusteredXidTransactionID
implements XidTransactionID {
    private final Xid xid;
    private volatile Decision decision = Decision.IN_DOUBT;

    public ClusteredXidTransactionID(Xid xid) {
        this.xid = new XidClustered(xid);
    }

    public synchronized boolean isDecisionCommit() {
        return this.decision.equals((Object)Decision.COMMIT);
    }

    public synchronized void markForCommit() {
        if (this.decision.equals((Object)Decision.ROLLBACK)) {
            throw new IllegalStateException(this + " already marked for rollback, cannot re-mark it for commit");
        }
        this.decision = Decision.COMMIT;
    }

    public synchronized boolean isDecisionRollback() {
        return this.decision.equals((Object)Decision.ROLLBACK);
    }

    public synchronized void markForRollback() {
        if (this.decision.equals((Object)Decision.COMMIT)) {
            throw new IllegalStateException(this + " already marked for commit, cannot re-mark it for rollback");
        }
        this.decision = Decision.ROLLBACK;
    }

    public Xid getXid() {
        return this.xid;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ClusteredXidTransactionID) {
            ClusteredXidTransactionID otherId = (ClusteredXidTransactionID)obj;
            return this.xid.equals(otherId.xid);
        }
        return false;
    }

    public final int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return "Clustered [" + this.xid + "] (decision: " + (Object)((Object)this.decision) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Decision {
        IN_DOUBT,
        COMMIT,
        ROLLBACK;

    }
}

