/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.transaction;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Element;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.local.LocalTransactionContext;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.modules.ehcache.transaction.ReadCommittedClusteredSoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCommittedClusteredSoftLockFactory
implements SoftLockFactory {
    private static final Object MARKER = new Object();
    private final String cacheName;
    private final String cacheManagerName;
    private final ConcurrentMap<ReadCommittedClusteredSoftLock, Object> newKeyLocks = new ConcurrentDistributedMap();
    private final ConcurrentMap<ReadCommittedClusteredSoftLock, Object> allLocks = new ConcurrentDistributedMap();

    public ReadCommittedClusteredSoftLockFactory(String cacheManagerName, String cacheName) {
        this.cacheManagerName = cacheManagerName;
        this.cacheName = cacheName;
    }

    String getCacheName() {
        return this.cacheName;
    }

    String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public SoftLock createSoftLock(TransactionID transactionID, Object key, Element newElement, Element oldElement, boolean pinned) {
        ReadCommittedClusteredSoftLock softLock = new ReadCommittedClusteredSoftLock(this, transactionID, key, newElement, oldElement, pinned);
        this.allLocks.put(softLock, MARKER);
        if (oldElement == null) {
            this.newKeyLocks.put(softLock, MARKER);
        }
        return softLock;
    }

    ReadCommittedClusteredSoftLock getLock(TransactionID transactionId, Object key) {
        for (ReadCommittedClusteredSoftLock readCommittedSoftLock : this.allLocks.keySet()) {
            if (!readCommittedSoftLock.getTransactionID().equals(transactionId) || !readCommittedSoftLock.getKey().equals(key)) continue;
            return readCommittedSoftLock;
        }
        return null;
    }

    public Set<Object> getKeysInvisibleInContext(LocalTransactionContext currentTransactionContext) {
        HashSet<Object> invisibleKeys = new HashSet<Object>();
        invisibleKeys.addAll(this.getNewKeys());
        List currentTransactionContextSoftLocks = currentTransactionContext.getSoftLocksForCache(this.cacheName);
        for (SoftLock softLock : currentTransactionContextSoftLocks) {
            if (softLock.getElement(currentTransactionContext.getTransactionId()) == null) {
                invisibleKeys.add(softLock.getKey());
                continue;
            }
            invisibleKeys.remove(softLock.getKey());
        }
        return invisibleKeys;
    }

    public synchronized Set<TransactionID> collectExpiredTransactionIDs() {
        HashSet<TransactionID> result = new HashSet<TransactionID>();
        for (ReadCommittedClusteredSoftLock softLock : this.allLocks.keySet()) {
            this.allLocks.get(softLock);
            if (!softLock.isExpired()) continue;
            result.add(softLock.getTransactionID());
        }
        return result;
    }

    public Set<SoftLock> collectAllSoftLocksForTransactionID(TransactionID transactionID) {
        HashSet<SoftLock> result = new HashSet<SoftLock>();
        for (ReadCommittedClusteredSoftLock softLock : this.allLocks.keySet()) {
            this.allLocks.get(softLock);
            if (!softLock.getTransactionID().equals(transactionID)) continue;
            result.add(softLock);
        }
        return result;
    }

    void clearSoftLock(ReadCommittedClusteredSoftLock softLock) {
        this.newKeyLocks.remove(softLock);
        this.allLocks.remove(softLock);
    }

    private Set<Object> getNewKeys() {
        HashSet<Object> result = new HashSet<Object>();
        for (ReadCommittedClusteredSoftLock softLock : this.newKeyLocks.keySet()) {
            this.newKeyLocks.get(softLock);
            result.add(softLock.getKey());
        }
        return result;
    }
}

