/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.transaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.TransactionID;
import org.terracotta.locking.TerracottaReadWriteLock;
import org.terracotta.modules.ehcache.transaction.ReadCommittedClusteredSoftLockFactory;

@IgnoreSizeOf
public class ReadCommittedClusteredSoftLock
implements SoftLock {
    private final ReadCommittedClusteredSoftLockFactory factory;
    private final String cacheManagerName;
    private final String cacheName;
    private final TransactionID transactionID;
    private final boolean pinned;
    private final byte[] key;
    private byte[] newElement;
    private final byte[] oldElement;
    private final TerracottaReadWriteLock lock;
    private final TerracottaReadWriteLock freezeLock;
    private final TerracottaReadWriteLock notificationLock;
    private final Condition notifier;
    private boolean expired;

    ReadCommittedClusteredSoftLock(ReadCommittedClusteredSoftLockFactory factory, TransactionID transactionID, Object key, Element newElement, Element oldElement, boolean pinned) {
        this.factory = factory;
        this.cacheManagerName = factory.getCacheManagerName();
        this.cacheName = factory.getCacheName();
        this.transactionID = transactionID;
        this.pinned = pinned;
        this.key = ReadCommittedClusteredSoftLock.serialize(key);
        this.newElement = ReadCommittedClusteredSoftLock.serialize(newElement);
        this.oldElement = ReadCommittedClusteredSoftLock.serialize(oldElement);
        this.lock = new TerracottaReadWriteLock();
        this.freezeLock = new TerracottaReadWriteLock();
        this.notificationLock = new TerracottaReadWriteLock();
        this.notifier = this.notificationLock.writeLock().newCondition();
    }

    public Object getKey() {
        return ReadCommittedClusteredSoftLock.deserialize(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(TransactionID currentTransactionId) {
        this.freezeLock.readLock().lock();
        try {
            if (this.transactionID.equals(currentTransactionId)) {
                Element element = (Element)ReadCommittedClusteredSoftLock.deserialize(this.newElement);
                return element;
            }
            Element element = (Element)ReadCommittedClusteredSoftLock.deserialize(this.oldElement);
            return element;
        }
        finally {
            this.freezeLock.readLock().unlock();
        }
    }

    public Element updateElement(Element e) {
        Element prev = (Element)ReadCommittedClusteredSoftLock.deserialize(this.newElement);
        this.newElement = ReadCommittedClusteredSoftLock.serialize(e);
        return prev;
    }

    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    public boolean wasPinned() {
        return this.pinned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        this.lock.writeLock().lock();
        if (this.isExpired()) {
            this.notificationLock.writeLock().lock();
            try {
                this.notifier.signalAll();
            }
            finally {
                this.notificationLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long ms) throws InterruptedException {
        if (this.isExpired() && this.factory.getLock(this.transactionID, ReadCommittedClusteredSoftLock.deserialize(this.key)) != null) {
            this.notificationLock.writeLock().lock();
            try {
                while (!this.isLocked()) {
                    boolean canLock = this.notifier.await(ms, TimeUnit.MILLISECONDS);
                    if (canLock) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.notificationLock.writeLock().unlock();
            }
        }
        return this.lock.writeLock().tryLock(ms, TimeUnit.MILLISECONDS);
    }

    public void clearTryLock() {
        this.lock.writeLock().unlock();
    }

    public void unlock() {
        this.lock.writeLock().unlock();
        this.clear();
    }

    boolean isLocked() {
        return ReadCommittedClusteredSoftLock.isLocked(this.lock);
    }

    public void freeze() {
        if (!this.isLocked()) {
            throw new IllegalStateException("cannot freeze an unlocked soft lock");
        }
        this.freezeLock.writeLock().lock();
    }

    public void unfreeze() {
        this.freezeLock.writeLock().unlock();
    }

    public Element getFrozenElement() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("cannot get frozen element of a soft lock which hasn't been frozen or hasn't expired");
        }
        if (this.transactionID.isDecisionCommit()) {
            return (Element)ReadCommittedClusteredSoftLock.deserialize(this.newElement);
        }
        return (Element)ReadCommittedClusteredSoftLock.deserialize(this.oldElement);
    }

    public synchronized boolean isExpired() {
        if (!this.expired) {
            this.expired = !this.isFrozen() && !this.isLocked();
        }
        return this.expired;
    }

    public void clear() {
        this.factory.clearSoftLock(this);
    }

    private boolean isFrozen() {
        return ReadCommittedClusteredSoftLock.isLocked(this.freezeLock);
    }

    private static boolean isLocked(TerracottaReadWriteLock lock) {
        if (lock.isWriteLockedByCurrentThread()) {
            return true;
        }
        boolean gotLock = lock.writeLock().tryLock();
        if (gotLock) {
            lock.writeLock().unlock();
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ReadCommittedClusteredSoftLock) {
            ReadCommittedClusteredSoftLock other = (ReadCommittedClusteredSoftLock)object;
            if (!this.transactionID.equals(other.transactionID)) {
                return false;
            }
            return Arrays.equals(this.key, other.key);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31;
        hashCode *= this.transactionID.hashCode();
        return hashCode *= Arrays.hashCode(this.key);
    }

    private Object writeReplace() {
        return new ReadCommittedClusteredSoftLockSerializedForm(this.cacheManagerName, this.cacheName, this.transactionID, this.key);
    }

    public String toString() {
        return "Soft Lock [clustered: true, isolation: rc, transactionID: " + this.transactionID + ", key: " + ReadCommittedClusteredSoftLock.deserialize(this.key) + ", newElement: " + ReadCommittedClusteredSoftLock.deserialize(this.newElement) + "]";
    }

    private static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("error serializing " + obj);
        }
    }

    private static Object deserialize(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("error deserializing " + bytes);
        }
    }

    private static final class ReadCommittedClusteredSoftLockSerializedForm
    implements Serializable {
        private final String cacheManagerName;
        private final String cacheName;
        private final TransactionID transactionID;
        private final byte[] key;

        private ReadCommittedClusteredSoftLockSerializedForm(String cacheManagerName, String cacheName, TransactionID transactionID, byte[] key) {
            this.cacheManagerName = cacheManagerName;
            this.cacheName = cacheName;
            this.transactionID = transactionID;
            this.key = key;
        }

        private Object readResolve() {
            for (int i = 0; i < CacheManager.ALL_CACHE_MANAGERS.size(); ++i) {
                CacheManager cacheManager = (CacheManager)CacheManager.ALL_CACHE_MANAGERS.get(i);
                if (!cacheManager.getName().equals(this.cacheManagerName)) continue;
                try {
                    ReadCommittedClusteredSoftLockFactory softLockFactory = (ReadCommittedClusteredSoftLockFactory)cacheManager.getSoftLockFactory(this.cacheName);
                    return softLockFactory.getLock(this.transactionID, ReadCommittedClusteredSoftLock.deserialize(this.key));
                }
                catch (CacheException ce) {
                    throw new TransactionException("cannot deserialize SoftLock from cache " + this.cacheName + " as the cache cannot be found in cache manager " + this.cacheManagerName);
                }
            }
            throw new TransactionException("unable to find referent clustered SoftLock in " + this.cacheManagerName + " " + this.cacheName + " for key [" + ReadCommittedClusteredSoftLock.deserialize(this.key) + "] under transaction " + this.transactionID);
        }
    }
}

