/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.transaction;

import javax.transaction.xa.Xid;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.xa.XidTransactionID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.transaction.ClusteredTransactionID;
import org.terracotta.modules.ehcache.transaction.xa.ClusteredXidTransactionID;

public class ClusteredTransactionIDFactory
implements TransactionIDFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusteredTransactionIDFactory.class.getName());
    private final String clusterUUID;

    public ClusteredTransactionIDFactory(String clusterUUID) {
        this.clusterUUID = clusterUUID;
        LOG.debug("ClusteredTransactionIDFactory UUID: {}", (Object)clusterUUID);
    }

    public TransactionID createTransactionID() {
        return new ClusteredTransactionID(this.clusterUUID);
    }

    public XidTransactionID createXidTransactionID(Xid xid) {
        return new ClusteredXidTransactionID(xid);
    }
}

