/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.transaction.TransactionID;

public class ClusteredTransactionID
implements TransactionID {
    private static final AtomicInteger idGenerator = new AtomicInteger();
    private final String clusterUUID;
    private final long creationTime;
    private final int id;
    private volatile boolean commit;

    ClusteredTransactionID(String clusterUUID) {
        this.clusterUUID = clusterUUID;
        this.creationTime = System.currentTimeMillis();
        this.id = idGenerator.getAndIncrement();
    }

    public synchronized boolean isDecisionCommit() {
        return this.commit;
    }

    public synchronized void markForCommit() {
        this.commit = true;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ClusteredTransactionID) {
            ClusteredTransactionID otherId = (ClusteredTransactionID)obj;
            return this.id == otherId.id && this.clusterUUID.equals(otherId.clusterUUID) && this.creationTime == otherId.creationTime;
        }
        return false;
    }

    public final int hashCode() {
        return (this.id + (int)this.creationTime) * 31 ^ this.clusterUUID.hashCode();
    }

    public String toString() {
        return this.id + ":" + this.creationTime + "@" + this.clusterUUID + (this.commit ? " (marked for commit)" : "");
    }
}

