/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.servermap;

import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStore;
import com.terracotta.toolkit.collections.servermap.api.adapters.ServerMapLocalStoreFactoryAdapter;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheInitializationHelper;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.constructs.classloader.InternalClassLoaderAwareCache;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.terracotta.InternalEhcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.collections.servermap.ServerMapLocalStoreConfig;
import org.terracotta.modules.ehcache.LocalVMResources;
import org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory;
import org.terracotta.modules.ehcache.store.servermap.EhcacheSMLocalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMapLocalStoreFactoryImpl
extends ServerMapLocalStoreFactoryAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMapLocalStoreFactoryImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalEhcache getOrCreateEhcacheLocalCache(CacheManager cacheManager, CacheInitializationHelper cacheInitializer, CacheConfiguration localStoreCacheConfig) {
        InternalEhcache localStoreCache = null;
        CacheManager cacheManager2 = cacheManager;
        synchronized (cacheManager2) {
            localStoreCache = LocalVMResources.getInstance().getRegisteredCache(cacheManager, localStoreCacheConfig.getName());
            if (localStoreCache == null) {
                localStoreCache = new Cache(localStoreCacheConfig);
                if (localStoreCacheConfig.isOverflowToOffHeap()) {
                    ClassLoader l1Loader = TerracottaClusteredInstanceFactory.class.getClassLoader();
                    localStoreCache = new InternalClassLoaderAwareCache(localStoreCache, l1Loader);
                }
                cacheInitializer.initializeEhcache((Ehcache)localStoreCache);
                localStoreCache.getCacheEventNotificationService().registerListener((CacheEventListener)new CacheDisposalEventListener((Ehcache)localStoreCache));
                LocalVMResources.getInstance().registerCache((Ehcache)localStoreCache);
            }
        }
        return localStoreCache;
    }

    public <K, V> ServerMapLocalStore<K, V> getOrCreateServerMapLocalStore(ServerMapLocalStoreConfig config) {
        CacheManager cacheManager = LocalVMResources.getInstance().getRegisteredCacheManager(config.getLocalStoreManagerName());
        CacheInitializationHelper cacheInitializer = new CacheInitializationHelper(cacheManager);
        if (cacheManager == null) {
            throw new AssertionError((Object)("CacheManager is null, localStoreCacheManagerName: " + config.getLocalStoreManagerName()));
        }
        InternalEhcache localStoreCache = this.getOrCreateEhcacheLocalCache(cacheManager, cacheInitializer, this.getLocalStoreCacheConfig(cacheManager, config));
        EhcacheSMLocalStore serverMapLocalStore = new EhcacheSMLocalStore(localStoreCache);
        return serverMapLocalStore;
    }

    private Ehcache getAppLayerClusteredEhcache(CacheManager cacheManager, ServerMapLocalStoreConfig config) {
        String name = config.getLocalStoreName();
        Ehcache appCache = cacheManager.getEhcache(name);
        if (appCache == null) {
            appCache = LocalVMResources.getInstance().getRegisteredCache(cacheManager, name);
        }
        if (appCache == null) {
            LOGGER.warn("Cache name '" + name + "' not found in local vm resources either");
            String msg = "Clustered Cache with name '" + name + "' not found in local CacheManager (looked up using id: '" + config.getLocalStoreManagerName() + "'). Are you sure you have the same ehcache.xml in all nodes?";
            LOGGER.error(msg);
            throw new AssertionError((Object)msg);
        }
        return appCache;
    }

    private CacheConfiguration getLocalStoreCacheConfig(CacheManager cacheManager, ServerMapLocalStoreConfig config) {
        PinningConfiguration pinningConfig;
        long maxBytesLocalOffHeap;
        Ehcache appCache = this.getAppLayerClusteredEhcache(cacheManager, config);
        CacheConfiguration appCacheConfig = appCache.getCacheConfiguration();
        CacheConfiguration localStoreConfig = new CacheConfiguration(this.getLocalCacheName(appCache), 0);
        localStoreConfig.setOverflowToDisk(false);
        if (appCacheConfig.getMaxEntriesLocalHeap() > 0L) {
            localStoreConfig.setMaxEntriesLocalHeap(appCacheConfig.getMaxEntriesLocalHeap() * 2L + 1L);
        }
        if (appCacheConfig.getMaxBytesLocalHeap() > 0L) {
            localStoreConfig.setMaxBytesLocalHeap(Long.valueOf(appCacheConfig.getMaxBytesLocalHeap()));
        }
        localStoreConfig.setOverflowToOffHeap(appCacheConfig.isOverflowToOffHeap());
        if (appCacheConfig.isOverflowToOffHeap() && (maxBytesLocalOffHeap = appCacheConfig.getMaxBytesLocalOffHeap()) > 0L) {
            localStoreConfig.setMaxBytesLocalOffHeap(Long.valueOf(maxBytesLocalOffHeap));
        }
        if ((pinningConfig = appCacheConfig.getPinningConfiguration()) != null) {
            localStoreConfig.addPinning(new PinningConfiguration().store(pinningConfig.getStore()));
        }
        localStoreConfig.setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy.CLOCK);
        return localStoreConfig;
    }

    private String getLocalCacheName(Ehcache cache) {
        return "local-shadow-cache-for-" + cache.getName() + "-uuid-" + cache.getGuid();
    }

    private static class CacheDisposalEventListener
    extends CacheEventListenerAdapter {
        private final Ehcache cache;

        private CacheDisposalEventListener(Ehcache cache) {
            this.cache = cache;
        }

        public void dispose() {
            LocalVMResources.getInstance().unregisterCache(this.cache);
        }
    }
}

