/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.servermap;

import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreFullException;
import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreListener;
import com.terracotta.toolkit.collections.servermap.api.adapters.ServerMapLocalStoreAdapter;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.terracotta.InternalEhcache;
import org.terracotta.modules.ehcache.store.servermap.ServerMapLocalStoreEhcacheListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineEhcacheSMLocalStore
extends ServerMapLocalStoreAdapter<Object, Object> {
    private final InternalEhcache localStoreCache;

    public OnlineEhcacheSMLocalStore(InternalEhcache localStoreCache) {
        this.localStoreCache = localStoreCache;
    }

    public boolean addListener(ServerMapLocalStoreListener<Object, Object> listener) {
        return this.localStoreCache.getCacheEventNotificationService().registerListener((CacheEventListener)new ServerMapLocalStoreEhcacheListenerAdapter(listener));
    }

    public boolean removeListener(ServerMapLocalStoreListener<Object, Object> listener) {
        return this.localStoreCache.getCacheEventNotificationService().unregisterListener((CacheEventListener)new ServerMapLocalStoreEhcacheListenerAdapter(listener));
    }

    public Object get(Object key) {
        Element element = this.localStoreCache.get(key);
        return element == null ? null : element.getObjectValue();
    }

    public List<Object> getKeys() {
        return this.localStoreCache.getKeys();
    }

    public Object put(Object key, Object value) throws ServerMapLocalStoreFullException {
        try {
            Element element = this.localStoreCache.get(key);
            this.localStoreCache.put(new Element(key, value));
            return element == null ? null : element.getObjectValue();
        }
        catch (CacheException e) {
            this.handleCacheException(e);
            throw e;
        }
    }

    public Object replace(Object key, Object oldValue, Object newValue) {
        Element element = this.localStoreCache.get(key);
        if (element == null || !oldValue.equals(element.getObjectValue())) {
            return null;
        }
        if (!this.localStoreCache.remove(key)) {
            return null;
        }
        Element newElement = new Element(key, newValue);
        newElement.setEternal(element.isEternal());
        this.localStoreCache.put(newElement);
        return element.getObjectValue();
    }

    public Object remove(Object key) {
        Element element = this.localStoreCache.removeAndReturnElement(key);
        return element == null ? null : element.getObjectValue();
    }

    public Object remove(Object key, Object value) {
        Element element = this.localStoreCache.get(key);
        if (element == null || !value.equals(element.getObjectValue())) {
            return null;
        }
        boolean removed = this.localStoreCache.remove(key);
        if (removed) {
            return element.getObjectValue();
        }
        return null;
    }

    public int getMaxEntriesLocalHeap() {
        return (int)this.localStoreCache.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    public void setMaxEntriesLocalHeap(int newValue) {
        this.localStoreCache.getCacheConfiguration().setMaxEntriesLocalHeap((long)newValue);
    }

    private void handleCacheException(CacheException ce) throws ServerMapLocalStoreFullException, CacheException {
        Throwable rootCause = this.getRootCause(ce);
        if (rootCause.getClass().getName().contains("OversizeMappingException") || rootCause.getClass().getName().contains("CrossPoolEvictionException")) {
            throw new ServerMapLocalStoreFullException();
        }
        throw ce;
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable t = throwable;
        if (t == null) {
            throw new AssertionError((Object)"Tried to find the root cause of null");
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public void unpinAll() {
        this.localStoreCache.unpinAll();
    }

    public boolean isPinned(Object key) {
        return this.localStoreCache.isPinned(key);
    }

    public void setPinned(Object key, boolean pinned) {
        this.localStoreCache.setPinned(key, pinned);
    }

    public void clear() {
        this.localStoreCache.removeAll();
    }

    public long getOnHeapSizeInBytes() {
        return this.localStoreCache.calculateInMemorySize();
    }

    public long getOffHeapSizeInBytes() {
        return this.localStoreCache.calculateOffHeapSize();
    }

    public int getOffHeapSize() {
        return (int)this.localStoreCache.getOffHeapStoreSize();
    }

    public int getOnHeapSize() {
        return (int)this.localStoreCache.getMemoryStoreSize();
    }

    public int getSize() {
        return this.localStoreCache.getSize();
    }

    public void dispose() {
    }

    public boolean containsKeyOnHeap(Object key) {
        return this.localStoreCache.isElementInMemory(key);
    }

    public boolean containsKeyOffHeap(Object key) {
        return this.localStoreCache.isKeyInCache(key);
    }

    public void setMaxBytesLocalHeap(long newMaxBytesLocalHeap) {
        this.localStoreCache.getCacheConfiguration().setMaxBytesLocalHeap(Long.valueOf(newMaxBytesLocalHeap));
    }

    public long getMaxBytesLocalHeap() {
        return this.localStoreCache.getCacheConfiguration().getMaxBytesLocalHeap();
    }

    public void recalculateSize(Object key) {
        this.localStoreCache.recalculateSize(key);
    }
}

