/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.servermap;

import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreListener;
import com.terracotta.toolkit.collections.servermap.api.adapters.ServerMapLocalStoreAdapter;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.Ehcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.store.servermap.EhcacheSMLocalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineEhcacheSMLocalStore
extends ServerMapLocalStoreAdapter<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheSMLocalStore.class);
    private final Ehcache localEhcache;

    public OfflineEhcacheSMLocalStore(Ehcache localEhcache) {
        this.localEhcache = localEhcache;
    }

    public boolean addListener(ServerMapLocalStoreListener<Object, Object> listener) {
        LOGGER.info("Ignoring addListener: " + listener + " as inner cache is not alive.");
        return false;
    }

    public boolean removeListener(ServerMapLocalStoreListener<Object, Object> listener) {
        LOGGER.info("Ignoring removeListener: " + listener + " as inner cache is not alive.");
        return false;
    }

    public Object get(Object key) {
        LOGGER.info("Ignoring get for key: " + key + " as inner cache is not alive.");
        return null;
    }

    public List<Object> getKeys() {
        LOGGER.info("Ignoring getKeySet as inner cache is not alive.");
        return Collections.EMPTY_LIST;
    }

    public Object put(Object key, Object value) {
        LOGGER.info("Ignoring put for key: " + key + ", value: " + value + " as inner cache is not alive.");
        return null;
    }

    public Object replace(Object key, Object oldValue, Object newValue) {
        LOGGER.info("Ignoring put for key: " + key + ", value: " + oldValue + " as inner cache is not alive.");
        return null;
    }

    public Object remove(Object key) {
        LOGGER.info("Ignoring remove for key " + key + " as inner cache is not alive.");
        return null;
    }

    public Object remove(Object key, Object value) {
        LOGGER.info("Ignoring remove for key " + key + " as inner cache is not alive.");
        return null;
    }

    public int getMaxEntriesLocalHeap() {
        return (int)this.localEhcache.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    public void setMaxEntriesLocalHeap(int newValue) {
        LOGGER.info("Ignoring setMaxEntriesLocalHeap with value: " + newValue + " as inner cache is not alive.");
    }

    public void unpinAll() {
        LOGGER.info("Ignoring unpinAll as inner cache is not alive.");
    }

    public boolean isPinned(Object key) {
        LOGGER.info("Ignoring isPinned for key: " + key + " as inner cache is not alive.");
        return false;
    }

    public void setPinned(Object key, boolean pinned) {
        LOGGER.info("Ignoring setPinned for key: " + key + ", pinned: " + pinned + " as inner cache is not alive.");
    }

    public void clear() {
        LOGGER.info("Ignoring clear as inner cache is not alive.");
    }

    public long getOnHeapSizeInBytes() {
        LOGGER.info("Ignoring getOnHeapSizeInBytes as inner cache is not alive.");
        return 0L;
    }

    public long getOffHeapSizeInBytes() {
        LOGGER.info("Ignoring getOffHeapSizeInBytes as inner cache is not alive.");
        return 0L;
    }

    public int getOffHeapSize() {
        LOGGER.info("Ignoring getOffHeapSize as inner cache is not alive.");
        return 0;
    }

    public int getOnHeapSize() {
        LOGGER.info("Ignoring getOnHeapSize as inner cache is not alive.");
        return 0;
    }

    public int getSize() {
        LOGGER.info("Ignoring getSize as inner cache is not alive.");
        return 0;
    }

    public void dispose() {
    }

    public boolean containsKeyOnHeap(Object key) {
        LOGGER.info("Ignoring containsKeyOnHeap for key: " + key + " as inner cache is not alive.");
        return false;
    }

    public boolean containsKeyOffHeap(Object key) {
        LOGGER.info("Ignoring containsKeyOffHeap for key: " + key + " as inner cache is not alive.");
        return false;
    }

    public void setMaxBytesLocalHeap(long newMaxBytesLocalHeap) {
        LOGGER.info("Ignoring setMaxBytesLocalHeap with value: " + newMaxBytesLocalHeap + " as inner cache is not alive.");
    }

    public long getMaxBytesLocalHeap() {
        return this.localEhcache.getCacheConfiguration().getMaxBytesLocalHeap();
    }

    public void recalculateSize(Object key) {
        LOGGER.info("Ignoring recalculateSize as inner cache is not alive.");
    }
}

