/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.servermap;

import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStore;
import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreFullException;
import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreListener;
import com.terracotta.toolkit.collections.servermap.api.adapters.ServerMapLocalStoreAdapter;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import net.sf.ehcache.terracotta.InternalEhcache;
import org.terracotta.modules.ehcache.store.servermap.OfflineEhcacheSMLocalStore;
import org.terracotta.modules.ehcache.store.servermap.OnlineEhcacheSMLocalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheSMLocalStore
extends ServerMapLocalStoreAdapter<Object, Object> {
    private final InternalEhcache localStoreCache;
    private final Lock writeLock;
    private final Lock readLock;
    private boolean running = true;
    private final OfflineEhcacheSMLocalStore offlineStore;
    private final OnlineEhcacheSMLocalStore onlineStore;

    public EhcacheSMLocalStore(InternalEhcache localStoreCache) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
        this.localStoreCache = localStoreCache;
        this.localStoreCache.getCacheEventNotificationService().registerListener((CacheEventListener)new CacheEventListenerAdapter(){

            public void dispose() {
                EhcacheSMLocalStore.this.cacheDisposed();
            }
        });
        this.offlineStore = new OfflineEhcacheSMLocalStore((Ehcache)localStoreCache);
        this.onlineStore = new OnlineEhcacheSMLocalStore(localStoreCache);
    }

    private void cacheDisposed() {
        this.writeLock.lock();
        this.running = false;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMapLocalStore getActiveStore() {
        this.readLock.lock();
        try {
            if (this.running && this.localStoreCache.getStatus() == Status.STATUS_ALIVE) {
                OnlineEhcacheSMLocalStore onlineEhcacheSMLocalStore = this.onlineStore;
                return onlineEhcacheSMLocalStore;
            }
            OfflineEhcacheSMLocalStore offlineEhcacheSMLocalStore = this.offlineStore;
            return offlineEhcacheSMLocalStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean addListener(ServerMapLocalStoreListener<Object, Object> listener) {
        return this.getActiveStore().addListener(listener);
    }

    public boolean removeListener(ServerMapLocalStoreListener<Object, Object> listener) {
        return this.getActiveStore().removeListener(listener);
    }

    public Object get(Object key) {
        return this.getActiveStore().get(key);
    }

    public List<Object> getKeys() {
        return this.getActiveStore().getKeys();
    }

    public Object put(Object key, Object value) throws ServerMapLocalStoreFullException {
        return this.getActiveStore().put(key, value);
    }

    public Object replace(Object key, Object oldValue, Object newValue) {
        return this.getActiveStore().replace(key, oldValue, newValue);
    }

    public Object remove(Object key) {
        return this.getActiveStore().remove(key);
    }

    public Object remove(Object key, Object value) {
        return this.getActiveStore().remove(key, value);
    }

    public int getMaxEntriesLocalHeap() {
        return this.getActiveStore().getMaxEntriesLocalHeap();
    }

    public void setMaxEntriesLocalHeap(int newValue) {
        this.getActiveStore().setMaxEntriesLocalHeap(newValue);
    }

    public void unpinAll() {
        this.getActiveStore().unpinAll();
    }

    public boolean isPinned(Object key) {
        return this.getActiveStore().isPinned(key);
    }

    public void setPinned(Object key, boolean pinned) {
        this.getActiveStore().setPinned(key, pinned);
    }

    public void clear() {
        this.getActiveStore().clear();
    }

    public long getOnHeapSizeInBytes() {
        return this.getActiveStore().getOnHeapSizeInBytes();
    }

    public long getOffHeapSizeInBytes() {
        return this.getActiveStore().getOffHeapSizeInBytes();
    }

    public int getOffHeapSize() {
        return this.getActiveStore().getOffHeapSize();
    }

    public int getOnHeapSize() {
        return this.getActiveStore().getOnHeapSize();
    }

    public int getSize() {
        return this.getActiveStore().getSize();
    }

    public void dispose() {
        this.cacheDisposed();
        this.localStoreCache.dispose();
    }

    public boolean containsKeyOnHeap(Object key) {
        return this.getActiveStore().containsKeyOnHeap(key);
    }

    public boolean containsKeyOffHeap(Object key) {
        return this.getActiveStore().containsKeyOffHeap(key);
    }

    public void setMaxBytesLocalHeap(long newMaxBytesLocalHeap) {
        this.getActiveStore().setMaxBytesLocalHeap(newMaxBytesLocalHeap);
    }

    public long getMaxBytesLocalHeap() {
        return this.getActiveStore().getMaxBytesLocalHeap();
    }

    Ehcache getLocalEhcache() {
        return this.localStoreCache;
    }

    public void recalculateSize(Object key) {
        this.getActiveStore().recalculateSize(key);
    }
}

