/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.backend;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.store.ClusteredElementEvictionData;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.UnmodifiableCollectionWrapper;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.modules.ehcache.store.backend.BackendStore;
import org.terracotta.modules.ehcache.store.backend.RealObjectKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictBackend
implements BackendStore {
    private final ClusteredStoreBackend<Object, Object> actualBackend;
    private final ValueModeHandler valueModeHandler;
    private final ClusteredStore clusteredStore;
    private final CacheCoherence cacheCoherence;

    public StrictBackend(ClusteredStore clusteredStore, ClusteredStoreBackend<Object, Object> actualBackend, ValueModeHandler valueModeHandler, CacheCoherence cacheCoherence) {
        this.clusteredStore = clusteredStore;
        this.actualBackend = actualBackend;
        this.valueModeHandler = valueModeHandler;
        this.cacheCoherence = cacheCoherence;
    }

    @Override
    public void putNoReturn(Object portableKey, TimestampedValue value, MetaData searchMetaData) {
        this.actualBackend.putNoReturn(portableKey, value, searchMetaData);
        this.valueModeHandler.processStoredValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllNoReturn(Collection<Element> elements) {
        for (Element element : elements) {
            this.cacheCoherence.acquireReadLock();
            try {
                Object portableKey = this.clusteredStore.generatePortableKeyFor(element.getObjectKey());
                MetaData searchMetaData = this.clusteredStore.createPutSearchMetaData(portableKey, element);
                TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                this.putNoReturn(portableKey, value, searchMetaData);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
    }

    @Override
    public Element get(Object actualKey, Object portableKey, boolean quiet) {
        TimestampedValue timestampedValue = quiet ? this.actualBackend.getTimestampedValueQuiet(portableKey) : this.actualBackend.getTimestampedValue(portableKey);
        return this.valueModeHandler.createElement(actualKey, timestampedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Element> getAll(Collection<?> keys, boolean quiet) {
        HashMap<Object, Element> rv = new HashMap<Object, Element>();
        for (Object key : keys) {
            Object pKey = this.clusteredStore.generatePortableKeyFor(key);
            this.cacheCoherence.acquireReadLock();
            try {
                rv.put(key, this.get(key, pKey, quiet));
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
        return rv;
    }

    @Override
    public void getAllInternal(Collection<Object> keys, boolean quiet, Map<Object, Element> rv) {
    }

    @Override
    public Element unlockedGet(Object actualKey, Object portableKey, boolean quiet) {
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.unlockedGetTimestampedValue(portableKey, quiet));
    }

    @Override
    public Element unsafeGet(Object actualKey, Object portableKey, boolean quiet) {
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.unsafeGetTimestampedValue(portableKey, quiet));
    }

    @Override
    public Element remove(Object actualKey, Object portableKey, MetaData metaData) {
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.removeTimestampedValue(portableKey, metaData));
    }

    @Override
    public void removeAll(Collection<?> keys, Map keyLookupCache) {
        for (Object key : keys) {
            Object portableKey = this.clusteredStore.generatePortableKeyFor(key);
            this.remove(key, portableKey, this.clusteredStore.createRemoveSearchMetaData(portableKey));
            if (keyLookupCache == null) continue;
            keyLookupCache.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object portableKey) {
        return this.actualBackend.containsKey(portableKey);
    }

    @Override
    public boolean containsLocalKey(Object portableKey) {
        return this.actualBackend.containsLocalKey(portableKey);
    }

    @Override
    public void clear(MetaData metaData) {
        this.actualBackend.clear(metaData);
    }

    @Override
    public int getInMemorySize() {
        return this.actualBackend.localSize();
    }

    @Override
    public List getKeys() {
        return new UnmodifiableCollectionWrapper(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.keySet(), false));
    }

    @Override
    public Set getLocalKeys() {
        return Collections.unmodifiableSet(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.localKeySet(), true));
    }

    @Override
    public int getSize() {
        return this.actualBackend.size();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return this.actualBackend.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element putIfAbsent(Object portableKey, Element element, MetaData searchMetaData) {
        ClusteredLock lock = this.actualBackend.createFinegrainedLock(portableKey);
        lock.lock();
        try {
            TimestampedValue oldValue = this.actualBackend.getTimestampedValueQuiet(portableKey);
            if (oldValue == null) {
                TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                this.actualBackend.putNoReturn(portableKey, value, searchMetaData);
                this.valueModeHandler.processStoredValue(value);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
                Element element2 = null;
                return element2;
            }
            Element element3 = this.valueModeHandler.createElement(element.getObjectKey(), oldValue);
            return element3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Object portableKey, Element element, ElementValueComparator comparator, MetaData metaData) {
        ClusteredLock lock = this.actualBackend.createFinegrainedLock(portableKey);
        lock.lock();
        try {
            TimestampedValue oldValue = this.actualBackend.getTimestampedValueQuiet(portableKey);
            Element oldElement = this.valueModeHandler.createElement(element.getObjectKey(), oldValue);
            if (comparator.equals(element, oldElement)) {
                this.actualBackend.removeNoReturn(portableKey, metaData);
                Element element2 = oldElement;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object portableKey, Element old, Element element, ElementValueComparator comparator, MetaData searchMetaData) {
        ClusteredLock lock = this.actualBackend.createFinegrainedLock(portableKey);
        lock.lock();
        try {
            Element currentElement = this.valueModeHandler.createElement(element.getObjectKey(), this.actualBackend.getTimestampedValueQuiet(portableKey));
            if (comparator.equals(old, currentElement)) {
                TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                this.actualBackend.putNoReturn(portableKey, value, searchMetaData);
                this.valueModeHandler.processStoredValue(value);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Object portableKey, Element element, MetaData searchMetaData) {
        ClusteredLock lock = this.actualBackend.createFinegrainedLock(portableKey);
        lock.lock();
        try {
            TimestampedValue currentValue = this.actualBackend.getTimestampedValueQuiet(portableKey);
            Element currentElement = this.valueModeHandler.createElement(element.getObjectKey(), currentValue);
            if (currentElement != null) {
                TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                this.actualBackend.putNoReturn(portableKey, value, searchMetaData);
                this.valueModeHandler.processStoredValue(value);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
            }
            Element element2 = currentElement;
            return element2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        return this.actualBackend.localOnHeapSizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytse() {
        return this.actualBackend.localOffHeapSizeInBytes();
    }

    @Override
    public int getLocalOnHeapSize() {
        return this.actualBackend.localOnHeapSize();
    }

    @Override
    public int getLocalOffHeapSize() {
        return this.actualBackend.localOffHeapSize();
    }

    @Override
    public boolean containsKeyLocalOnHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOnHeap(portableKey);
    }

    @Override
    public boolean containsKeyLocalOffHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOffHeap(portableKey);
    }
}

