/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.backend;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.terracotta.modules.ehcache.store.ValueModeHandler;

class RealObjectKeySet
extends AbstractSet {
    private final ValueModeHandler mode;
    private final Collection keys;
    private final boolean local;

    public RealObjectKeySet(ValueModeHandler mode, Collection keys, boolean local) {
        this.mode = mode;
        this.keys = keys;
        this.local = local;
    }

    public int size() {
        return this.keys.size();
    }

    public boolean contains(Object o) {
        return this.keys.contains(this.mode.createPortableKey(o));
    }

    public Iterator iterator() {
        return new KeyIterator(this.mode, this.keys.iterator(), this.local);
    }

    static class KeyIterator
    implements Iterator {
        private static final Object NO_OBJECT = new Object();
        private final Iterator keysIterator;
        private final ValueModeHandler mode;
        private final boolean local;
        private Object next;

        private KeyIterator(ValueModeHandler mode, Iterator iterator, boolean local) {
            this.mode = mode;
            this.keysIterator = iterator;
            this.local = local;
            this.advance();
        }

        private void advance() {
            this.next = NO_OBJECT;
            while (this.keysIterator.hasNext()) {
                Object real;
                if (this.local) {
                    real = this.mode.localGetRealKeyObject(this.keysIterator.next());
                    if (real == null) {
                        continue;
                    }
                } else {
                    real = this.mode.getRealKeyObject(this.keysIterator.next());
                }
                this.next = real;
                return;
            }
        }

        public boolean hasNext() {
            return this.next != NO_OBJECT;
        }

        public Object next() {
            Object rv = this.next;
            if (rv == NO_OBJECT) {
                throw new NoSuchElementException();
            }
            this.advance();
            return rv;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

