/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.backend;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.DefaultSizeOfEngine;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cluster.TerracottaProperties;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.locking.LockType;
import org.terracotta.locking.TerracottaLock;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.store.ClusteredElementEvictionData;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.UnmodifiableCollectionWrapper;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.modules.ehcache.store.backend.BackendStore;
import org.terracotta.modules.ehcache.store.backend.ClusteredElement;
import org.terracotta.modules.ehcache.store.backend.GetAllCustomMap;
import org.terracotta.modules.ehcache.store.backend.RealObjectKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonStrictBackend
implements BackendStore {
    private static final String EHCACHE_NON_STRICT_CONCURRENT_LOCKS_SIZE_PROPERTY = "ehcache.coherence.nonstrict.concurrentLocksSize";
    private static final String EHCAHE_BULKOPS_MAX_KB_SIZE = "ehcache.bulkOps.maxKBSize";
    private static final String EHCACHE_GETALL_BATCH_SIZE_PROPERTY = "ehcache.getAll.batchSize";
    private static final int DEFAULT_GETALL_BATCH_SIZE = 1000;
    private static final int DEFAULT_EHCACHE_NON_STRICT_CONCURRENT_LOCKS_SIZE = 256;
    private static final int EHCACHE_NON_STRICT_CONCURRENT_LOCKS_SIZE = Integer.getInteger("ehcache.coherence.nonstrict.concurrentLocksSize", 256);
    private static final int KB = 1024;
    private static int BULK_OPS_KB_SIZE = NonStrictBackend.getTerracottaProperty("ehcache.bulkOps.maxKBSize", 1024) * 1024;
    private static int GETALL_BATCH_SIZE = NonStrictBackend.getTerracottaProperty("ehcache.getAll.batchSize", 1000);
    private static final Logger LOG = LoggerFactory.getLogger((String)NonStrictBackend.class.getName());
    private final ClusteredStoreBackend<Object, Object> actualBackend;
    private final ValueModeHandler valueModeHandler;
    private final ThreadLocal<ClusteredStore.SyncLockState> synclockstate;
    private final ClusteredStore clusteredStore;
    private final CacheCoherence cacheCoherence;
    private static final TerracottaLock[] concurrentLocks = new TerracottaLock[EHCACHE_NON_STRICT_CONCURRENT_LOCKS_SIZE];
    private final SizeOfEngine sizeOfEngine;

    private static int getTerracottaProperty(String propName, int defaultValue) {
        try {
            return new TerracottaProperties().getInteger(propName, Integer.valueOf(defaultValue));
        }
        catch (UnsupportedOperationException e) {
            return defaultValue;
        }
    }

    public NonStrictBackend(ClusteredStore clusteredStore, ClusteredStoreBackend<Object, Object> actualBackend, ValueModeHandler valueModeHandler, ThreadLocal<ClusteredStore.SyncLockState> synclockstate, CacheCoherence cacheCoherence, int maxSizeOfDepth, boolean throwExceptionWhenMaxDepthReached) {
        this.clusteredStore = clusteredStore;
        this.actualBackend = actualBackend;
        this.valueModeHandler = valueModeHandler;
        this.synclockstate = synclockstate;
        this.cacheCoherence = cacheCoherence;
        this.sizeOfEngine = new DefaultSizeOfEngine(maxSizeOfDepth, throwExceptionWhenMaxDepthReached);
        if (BULK_OPS_KB_SIZE <= 0) {
            BULK_OPS_KB_SIZE = 0x100000;
            LOG.info("For bulk operations data will be transferred approximately in a batch of " + BULK_OPS_KB_SIZE + " Bytes.");
        }
    }

    private TerracottaLock getConcurrentLock(Object key) {
        return concurrentLocks[Math.abs(key.hashCode() % EHCACHE_NON_STRICT_CONCURRENT_LOCKS_SIZE)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putNoReturn(Object portableKey, TimestampedValue value, MetaData searchMetaData) {
        if (this.synclockstate.get().isLocked()) {
            this.actualBackend.putNoReturn(portableKey, value, searchMetaData);
        } else {
            TerracottaLock concurrentLock = this.getConcurrentLock(portableKey);
            concurrentLock.lock();
            try {
                this.actualBackend.unlockedPutNoReturn(portableKey, value, searchMetaData);
            }
            finally {
                concurrentLock.unlock();
            }
        }
        this.valueModeHandler.processStoredValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllNoReturn(Collection<Element> elements) {
        Iterator<Element> iter = elements.iterator();
        while (iter.hasNext()) {
            this.cacheCoherence.acquireReadLock();
            HashSet<ClusteredElement> batchedElements = new HashSet<ClusteredElement>();
            try {
                ClusteredElement clusteredElement;
                for (long currentByteSize = 0L; currentByteSize < (long)BULK_OPS_KB_SIZE && iter.hasNext(); currentByteSize += this.getElementSize(clusteredElement, false)) {
                    Element element = iter.next();
                    Object portableKey = this.clusteredStore.generatePortableKeyFor(element.getObjectKey());
                    MetaData searchMetaData = this.clusteredStore.createPutSearchMetaData(portableKey, element);
                    TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                    clusteredElement = new ClusteredElement(element.getObjectKey(), portableKey, searchMetaData, value);
                    batchedElements.add(clusteredElement);
                    element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
                }
                this.doPutAll(batchedElements);
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutAll(Set<ClusteredElement> elements) {
        if (this.synclockstate.get().isLocked()) {
            for (ClusteredElement element : elements) {
                this.actualBackend.putNoReturn(element.getPortableKey(), element.getTimeStampedValue(), element.getSearchMetaData());
            }
        } else {
            TerracottaLock concurrentLock = this.getConcurrentLock(elements.iterator().next().getPortableKey());
            concurrentLock.lock();
            try {
                for (ClusteredElement element : elements) {
                    this.actualBackend.unlockedPutNoReturn(element.getPortableKey(), element.getTimeStampedValue(), element.getSearchMetaData());
                }
            }
            finally {
                concurrentLock.unlock();
            }
        }
        for (ClusteredElement element : elements) {
            this.valueModeHandler.processStoredValue(element.getTimeStampedValue());
        }
    }

    private long getElementSize(ClusteredElement clusteredElement, boolean computeMetaDataSize) {
        return this.sizeOfEngine.sizeOf(clusteredElement.getPortableKey(), (Object)clusteredElement.getTimeStampedValue(), null).getCalculated();
    }

    @Override
    public Element get(Object actualKey, Object portableKey, boolean quiet) {
        if (this.synclockstate.get().isLocked()) {
            if (quiet) {
                return this.valueModeHandler.createElement(actualKey, this.actualBackend.getTimestampedValueQuiet(portableKey));
            }
            return this.valueModeHandler.createElement(actualKey, this.actualBackend.getTimestampedValue(portableKey));
        }
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.unlockedGetTimestampedValue(portableKey, quiet));
    }

    @Override
    public Map<Object, Element> getAll(Collection<?> keys, boolean quiet) {
        return new GetAllCustomMap(keys, this, quiet, GETALL_BATCH_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllInternal(Collection<Object> keys, boolean quiet, Map<Object, Element> rv) {
        HashMap<Object, Object> portableKeyActualKeyMap = new HashMap<Object, Object>();
        for (Object actualKey : keys) {
            portableKeyActualKeyMap.put(this.clusteredStore.generatePortableKeyFor(actualKey), actualKey);
        }
        this.cacheCoherence.acquireReadLock();
        try {
            Map<Object, TimestampedValue<Object>> valueMap = this.synclockstate.get().isLocked() ? this.actualBackend.getTimestampedValues(portableKeyActualKeyMap.keySet(), quiet) : this.actualBackend.unlockedGetAllTimeStampedValues(portableKeyActualKeyMap.keySet(), quiet);
            for (Map.Entry<Object, TimestampedValue<Object>> entry : valueMap.entrySet()) {
                Object actualKey = portableKeyActualKeyMap.get(entry.getKey());
                rv.put(actualKey, this.valueModeHandler.createElement(actualKey, entry.getValue()));
            }
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    @Override
    public Element unlockedGet(Object actualKey, Object portableKey, boolean quiet) {
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.unlockedGetTimestampedValue(portableKey, quiet));
    }

    @Override
    public Element unsafeGet(Object actualKey, Object portableKey, boolean quiet) {
        return this.valueModeHandler.createElement(actualKey, this.actualBackend.unsafeGetTimestampedValue(portableKey, quiet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element remove(Object actualKey, Object portableKey, MetaData metaData) {
        boolean externalLock = this.synclockstate.get().isLocked();
        TerracottaLock concurrentLock = null;
        if (!externalLock) {
            concurrentLock = this.getConcurrentLock(portableKey);
            concurrentLock.lock();
        }
        try {
            TimestampedValue timestampedValue = this.actualBackend.unlockedGetTimestampedValue(portableKey, true);
            this.actualBackend.unlockedRemoveNoReturn(portableKey, metaData);
            Element element = this.valueModeHandler.createElement(actualKey, timestampedValue);
            return element;
        }
        finally {
            if (!externalLock) {
                concurrentLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Collection<?> keys, Map keyLookupCache) {
        boolean externalLock = this.synclockstate.get().isLocked();
        TerracottaLock concurrentLock = null;
        Iterator<?> iter = keys.iterator();
        while (iter.hasNext()) {
            this.cacheCoherence.acquireReadLock();
            try {
                long currentByteSize = 0L;
                while (currentByteSize < (long)BULK_OPS_KB_SIZE && iter.hasNext()) {
                    Object key = iter.next();
                    Object portableKey = this.clusteredStore.generatePortableKeyFor(key);
                    currentByteSize += this.sizeOfEngine.sizeOf(portableKey, null, null).getCalculated();
                    if (keyLookupCache != null) {
                        keyLookupCache.remove(key);
                    }
                    if (!externalLock && concurrentLock == null) {
                        concurrentLock = this.getConcurrentLock(portableKey);
                        concurrentLock.lock();
                    }
                    MetaData metaData = this.clusteredStore.createRemoveSearchMetaData(portableKey);
                    this.actualBackend.unlockedRemoveNoReturn(portableKey, metaData);
                }
            }
            finally {
                if (concurrentLock != null) {
                    concurrentLock.unlock();
                }
                concurrentLock = null;
                this.cacheCoherence.releaseReadLock();
            }
        }
    }

    @Override
    public void clear(MetaData metaData) {
        this.actualBackend.clear(metaData);
    }

    @Override
    public boolean containsKey(Object portableKey) {
        if (this.synclockstate.get().isLocked()) {
            return this.actualBackend.containsKey(portableKey);
        }
        return this.actualBackend.unlockedContainsKey(portableKey);
    }

    @Override
    public boolean containsLocalKey(Object portableKey) {
        if (this.synclockstate.get().isLocked()) {
            return this.actualBackend.containsLocalKey(portableKey);
        }
        return this.actualBackend.unlockedContainsLocalKey(portableKey);
    }

    @Override
    public int getSize() {
        return this.actualBackend.size();
    }

    @Override
    public int getInMemorySize() {
        return this.actualBackend.localSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return this.actualBackend.size();
    }

    @Override
    public List getKeys() {
        return new UnmodifiableCollectionWrapper(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.keySet(), false));
    }

    @Override
    public Set getLocalKeys() {
        return Collections.unmodifiableSet(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.localKeySet(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element putIfAbsent(Object portableKey, Element element, MetaData searchMetaData) {
        TimestampedValue oldValue;
        TimestampedValue value;
        ClusteredLock lock;
        block6: {
            Element element2;
            lock = this.actualBackend.createFinegrainedLock(portableKey);
            lock.lock();
            value = null;
            try {
                oldValue = this.actualBackend.unlockedGetTimestampedValue(portableKey, true);
                if (oldValue != null) break block6;
                value = this.valueModeHandler.createTimestampedValue(element);
                this.actualBackend.unlockedPutIfAbsentNoReturn(portableKey, value, searchMetaData);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
                element2 = null;
            }
            catch (Throwable throwable) {
                lock.unlock();
                if (value != null) {
                    this.valueModeHandler.processStoredValue(value);
                }
                throw throwable;
            }
            lock.unlock();
            if (value != null) {
                this.valueModeHandler.processStoredValue(value);
            }
            return element2;
        }
        Element element3 = this.valueModeHandler.createElement(element.getObjectKey(), oldValue);
        lock.unlock();
        if (value != null) {
            this.valueModeHandler.processStoredValue(value);
        }
        return element3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Object portableKey, Element element, ElementValueComparator comparator, MetaData metaData) {
        boolean externalLock = this.synclockstate.get().isLocked();
        TerracottaLock concurrentLock = null;
        if (!externalLock) {
            concurrentLock = this.getConcurrentLock(portableKey);
            concurrentLock.lock();
        }
        try {
            TimestampedValue oldValue = this.actualBackend.unlockedGetTimestampedValue(portableKey, true);
            Element oldElement = this.valueModeHandler.createElement(element.getObjectKey(), oldValue);
            if (comparator.equals(element, oldElement)) {
                this.actualBackend.unlockedRemoveNoReturn(portableKey, oldValue, metaData);
                Element element2 = oldElement;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            if (!externalLock) {
                concurrentLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object portableKey, Element old, Element element, ElementValueComparator comparator, MetaData searchMetaData) {
        boolean bl;
        TimestampedValue newValue;
        block10: {
            TerracottaLock concurrentLock;
            boolean externalLock;
            block8: {
                boolean bl2;
                block9: {
                    externalLock = this.synclockstate.get().isLocked();
                    concurrentLock = null;
                    if (!externalLock) {
                        concurrentLock = this.getConcurrentLock(portableKey);
                        concurrentLock.lock();
                    }
                    newValue = null;
                    try {
                        TimestampedValue currentValue = this.actualBackend.unlockedGetTimestampedValue(portableKey, true);
                        Element currentElement = this.valueModeHandler.createElement(element.getObjectKey(), currentValue);
                        if (!comparator.equals(old, currentElement)) break block8;
                        newValue = this.valueModeHandler.createTimestampedValue(element);
                        this.actualBackend.unlockedReplaceNoReturn(portableKey, currentValue, newValue, searchMetaData);
                        element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, newValue));
                        bl2 = true;
                        if (externalLock) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!externalLock) {
                            concurrentLock.unlock();
                        }
                        if (newValue != null) {
                            this.valueModeHandler.processStoredValue(newValue);
                        }
                        throw throwable;
                    }
                    concurrentLock.unlock();
                }
                if (newValue != null) {
                    this.valueModeHandler.processStoredValue(newValue);
                }
                return bl2;
            }
            bl = false;
            if (externalLock) break block10;
            concurrentLock.unlock();
        }
        if (newValue != null) {
            this.valueModeHandler.processStoredValue(newValue);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Object portableKey, Element element, MetaData searchMetaData) {
        Element element2;
        TimestampedValue newValue;
        block7: {
            boolean externalLock = this.synclockstate.get().isLocked();
            TerracottaLock concurrentLock = null;
            if (!externalLock) {
                concurrentLock = this.getConcurrentLock(portableKey);
                concurrentLock.lock();
            }
            newValue = null;
            try {
                TimestampedValue currentValue = this.actualBackend.unlockedGetTimestampedValue(portableKey, true);
                Element currentElement = this.valueModeHandler.createElement(element.getObjectKey(), currentValue);
                if (currentElement != null) {
                    newValue = this.valueModeHandler.createTimestampedValue(element);
                    this.actualBackend.unlockedReplaceNoReturn(portableKey, currentValue, newValue, searchMetaData);
                    element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, newValue));
                }
                element2 = currentElement;
                if (externalLock) break block7;
            }
            catch (Throwable throwable) {
                if (!externalLock) {
                    concurrentLock.unlock();
                }
                if (newValue != null) {
                    this.valueModeHandler.processStoredValue(newValue);
                }
                throw throwable;
            }
            concurrentLock.unlock();
        }
        if (newValue != null) {
            this.valueModeHandler.processStoredValue(newValue);
        }
        return element2;
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        return this.actualBackend.localOnHeapSizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytse() {
        return this.actualBackend.localOffHeapSizeInBytes();
    }

    @Override
    public int getLocalOnHeapSize() {
        return this.actualBackend.localOnHeapSize();
    }

    @Override
    public int getLocalOffHeapSize() {
        return this.actualBackend.localOffHeapSize();
    }

    @Override
    public boolean containsKeyLocalOnHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOnHeap(portableKey);
    }

    @Override
    public boolean containsKeyLocalOffHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOffHeap(portableKey);
    }

    static {
        for (int i = 0; i < concurrentLocks.length; ++i) {
            NonStrictBackend.concurrentLocks[i] = new TerracottaLock((Object)("nonstrict-concurrent-lock-" + i), LockType.CONCURRENT);
        }
    }
}

