/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.backend;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.store.backend.BackendStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllCustomMap
extends AbstractMap<Object, Element> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GetAllCustomMap.class.getName());
    private final Collection<?> keys;
    private final Map<Object, Element>[] internalMaps;
    private final BackendStore backendStore;
    private final boolean[] fetchCompleted;
    private final boolean quiet;
    private final int getAllBatchSize;

    public GetAllCustomMap(Collection<?> keys, BackendStore backendStore, boolean quiet, int getAllBatchSize) {
        this.keys = keys;
        this.internalMaps = new Map[(int)Math.ceil((double)keys.size() / (double)getAllBatchSize)];
        this.fetchCompleted = new boolean[this.internalMaps.length];
        this.backendStore = backendStore;
        this.quiet = quiet;
        this.getAllBatchSize = getAllBatchSize;
        this.initMaps();
        this.fetchValuesForIndex(0);
    }

    private void initMaps() {
        int index;
        for (index = 0; index < this.internalMaps.length; ++index) {
            this.internalMaps[index] = new HashMap<Object, Element>();
        }
        index = 0;
        int counter = 0;
        for (Object key : this.keys) {
            if (counter == this.getAllBatchSize) {
                ++index;
                counter = 0;
            }
            this.internalMaps[index].put(key, null);
            ++counter;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue is not supported on this map implementation");
    }

    @Override
    public Element get(Object key) {
        int index = this.getMapIndexForKey(key);
        if (index == -1) {
            return null;
        }
        if (this.fetchCompleted[index]) {
            return this.internalMaps[index].get(key);
        }
        this.fetchValuesForIndex(index);
        return this.internalMaps[index].get(key);
    }

    private void fetchValuesForIndex(int index) {
        if (!this.fetchCompleted[index]) {
            this.backendStore.getAllInternal(this.internalMaps[index].keySet(), this.quiet, this.internalMaps[index]);
            this.fetchCompleted[index] = true;
        }
    }

    private int getMapIndexForKey(Object key) {
        for (int index = 0; index < this.internalMaps.length; ++index) {
            if (!this.internalMaps[index].containsKey(key)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public Element put(Object key, Element value) {
        if (!this.containsKey(key)) {
            throw new UnsupportedOperationException("putInternal is supported only for existing keys");
        }
        Map<Object, Element> mapForKey = this.internalMaps[this.getMapIndexForKey(key)];
        return mapForKey.put(key, value);
    }

    @Override
    public Element remove(Object key) {
        throw new UnsupportedOperationException("remove is not supported on this map implementation");
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Element> m) {
        for (Map.Entry<? extends Object, ? extends Element> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        for (Map<Object, Element> internalMap : this.internalMaps) {
            keySet.addAll(internalMap.keySet());
        }
        return keySet;
    }

    @Override
    public Collection<Element> values() {
        throw new UnsupportedOperationException("values is not supported on this map implementation");
    }

    @Override
    public Set<Map.Entry<Object, Element>> entrySet() {
        return new EntrySet();
    }

    static /* synthetic */ boolean[] access$400(GetAllCustomMap x0) {
        return x0.fetchCompleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<Map.Entry<Object, Element>> {
        Iterator<Map.Entry<Object, Element>> currentIterator;
        int index = 0;
        Map<Object, Element>[] intMaps = GetAllCustomMap.access$200(GetAllCustomMap.this);
        boolean[] fetched = GetAllCustomMap.access$400(GetAllCustomMap.this);

        EntryIterator() {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public Map.Entry<Object, Element> next() {
            Map.Entry<Object, Element> entry = this.currentIterator.next();
            this.advance();
            return entry;
        }

        private final void advance() {
            if (this.currentIterator == null) {
                this.currentIterator = this.intMaps[this.index].entrySet().iterator();
            } else if (!this.currentIterator.hasNext() && this.index < this.intMaps.length - 1) {
                ++this.index;
                if (!this.fetched[this.index]) {
                    GetAllCustomMap.this.fetchValuesForIndex(this.index);
                }
                this.currentIterator = this.intMaps[this.index].entrySet().iterator();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<Object, Element>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Element>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return GetAllCustomMap.this.keys.size();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("removeAll is not supported on this Set implementation");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove is not supported on this Set implementation");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll is not supported on this Set implementation");
        }

        @Override
        public void clear() {
            GetAllCustomMap.this.keys.clear();
            for (int index = 0; index < GetAllCustomMap.this.internalMaps.length; ++index) {
                ((GetAllCustomMap)GetAllCustomMap.this).internalMaps[index] = new HashMap();
                LOGGER.info("Map " + index + " cleared...");
            }
        }
    }
}

