/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.backend;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.store.ClusteredElementEvictionData;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.LocalBufferedMap;
import org.terracotta.modules.ehcache.store.UnmodifiableMultiCollectionSetWrapper;
import org.terracotta.modules.ehcache.store.UnmodifiableMultiCollectionWrapper;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.modules.ehcache.store.backend.BackendStore;
import org.terracotta.modules.ehcache.store.backend.RealObjectKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkLoadBackend
implements BackendStore {
    private final ClusteredStoreBackend<Object, Object> actualBackend;
    private final ValueModeHandler valueModeHandler;
    private final LocalBufferedMap<Object, TimestampedValue<Object>> localBufferedMap;
    private final ClusteredStore clusteredStore;
    private final CacheCoherence cacheCoherence;

    public BulkLoadBackend(ClusteredStore clusteredStore, ClusteredStoreBackend<Object, Object> actualBackend, ValueModeHandler valueModeHandler, LocalBufferedMap<Object, TimestampedValue<Object>> localBufferedMap, CacheCoherence cacheCoherence) {
        this.clusteredStore = clusteredStore;
        this.actualBackend = actualBackend;
        this.valueModeHandler = valueModeHandler;
        this.localBufferedMap = localBufferedMap;
        this.cacheCoherence = cacheCoherence;
    }

    @Override
    public void putNoReturn(Object portableKey, TimestampedValue value, MetaData searchMetaData) {
        this.localBufferedMap.put(portableKey, (TimestampedValue<Object>)value, searchMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllNoReturn(Collection<Element> elements) {
        for (Element element : elements) {
            this.cacheCoherence.acquireReadLock();
            try {
                Object portableKey = this.clusteredStore.generatePortableKeyFor(element.getObjectKey());
                MetaData searchMetaData = this.clusteredStore.createPutSearchMetaData(portableKey, element);
                TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                this.putNoReturn(portableKey, value, searchMetaData);
                element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.clusteredStore, value));
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
    }

    @Override
    public Element get(Object actualKey, Object portableKey, boolean quiet) {
        TimestampedValue value = null;
        value = this.localBufferedMap.get(portableKey);
        if (value == null) {
            value = this.actualBackend.unlockedGetTimestampedValue(portableKey, quiet);
        }
        return this.valueModeHandler.createElement(actualKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Element> getAll(Collection<?> keys, boolean quiet) {
        HashMap<Object, Element> rv = new HashMap<Object, Element>();
        for (Object key : keys) {
            Object pKey = this.clusteredStore.generatePortableKeyFor(key);
            this.cacheCoherence.acquireReadLock();
            try {
                rv.put(key, this.get(key, pKey, quiet));
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
        return rv;
    }

    @Override
    public void getAllInternal(Collection<Object> keys, boolean quiet, Map<Object, Element> rv) {
    }

    @Override
    public Element unlockedGet(Object actualKey, Object portableKey, boolean quiet) {
        TimestampedValue value = this.localBufferedMap.get(portableKey);
        if (value == null) {
            value = this.actualBackend.unlockedGetTimestampedValue(portableKey, quiet);
        }
        return this.valueModeHandler.createElement(actualKey, value);
    }

    @Override
    public Element unsafeGet(Object actualKey, Object portableKey, boolean quiet) {
        TimestampedValue value = this.localBufferedMap.get(portableKey);
        if (value == null) {
            value = this.actualBackend.unsafeGetTimestampedValue(portableKey, quiet);
        }
        return this.valueModeHandler.createElement(actualKey, value);
    }

    @Override
    public Element remove(Object actualKey, Object portableKey, MetaData metaData) {
        return this.valueModeHandler.createElement(actualKey, this.localBufferedMap.remove(portableKey, metaData));
    }

    @Override
    public void removeAll(Collection<?> keys, Map keyLookupCache) {
        for (Object key : keys) {
            Object portableKey = this.clusteredStore.generatePortableKeyFor(key);
            this.remove(key, portableKey, this.clusteredStore.createRemoveSearchMetaData(portableKey));
            if (keyLookupCache == null) continue;
            keyLookupCache.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object portableKey) {
        boolean rv = this.localBufferedMap.containsKey(portableKey);
        if (rv) {
            return true;
        }
        return this.actualBackend.unlockedContainsKey(portableKey);
    }

    @Override
    public boolean containsLocalKey(Object portableKey) {
        boolean rv = this.localBufferedMap.containsKey(portableKey);
        if (rv) {
            return true;
        }
        return this.actualBackend.unlockedContainsLocalKey(portableKey);
    }

    @Override
    public int getSize() {
        return this.localBufferedMap.getSize() + this.actualBackend.size();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return this.actualBackend.size();
    }

    @Override
    public int getInMemorySize() {
        return this.localBufferedMap.getSize() + this.actualBackend.localSize();
    }

    @Override
    public void clear(MetaData metaData) {
        this.localBufferedMap.clear(metaData);
        this.actualBackend.clear(metaData);
    }

    @Override
    public List getKeys() {
        return new UnmodifiableMultiCollectionWrapper(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.keySet(), false), new RealObjectKeySet(this.valueModeHandler, this.localBufferedMap.getKeys(), false));
    }

    @Override
    public Set getLocalKeys() {
        return new UnmodifiableMultiCollectionSetWrapper(new RealObjectKeySet(this.valueModeHandler, this.actualBackend.localKeySet(), true), new RealObjectKeySet(this.valueModeHandler, this.localBufferedMap.getKeys(), false));
    }

    @Override
    public Element putIfAbsent(Object portableKey, Element element, MetaData searchMetaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element removeElement(Object portableKey, Element element, ElementValueComparator comparator, MetaData metaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object portableKey, Element old, Element element, ElementValueComparator comparator, MetaData searchMetaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element replace(Object portableKey, Element element, MetaData searchMetaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLocalHeapSizeInBytes() {
        return this.actualBackend.localOnHeapSizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytse() {
        return this.actualBackend.localOffHeapSizeInBytes();
    }

    @Override
    public int getLocalOnHeapSize() {
        return this.actualBackend.localOnHeapSize();
    }

    @Override
    public int getLocalOffHeapSize() {
        return this.actualBackend.localOffHeapSize();
    }

    @Override
    public boolean containsKeyLocalOnHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOnHeap(portableKey);
    }

    @Override
    public boolean containsKeyLocalOffHeap(Object portableKey) {
        return this.actualBackend.containsKeyLocalOffHeap(portableKey);
    }
}

