/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import com.tc.object.bytecode.NotClearable;
import net.sf.ehcache.AbstractElementData;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.SerializationModeElementData;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.util.TimeUtil;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.serialization.CustomLifespanSerializedEntry;
import org.terracotta.cache.serialization.SerializationStrategy3;
import org.terracotta.cache.serialization.SerializedEntry;
import org.terracotta.cache.serialization.SerializedEntryParameters;
import org.terracotta.modules.ehcache.store.ClusteredElementEvictionData;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ElementSerializationStrategy;
import org.terracotta.modules.ehcache.store.ThreadContextAwareClassLoader;
import org.terracotta.modules.ehcache.store.ValueModeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValueModeHandlerSerialization
implements ValueModeHandler,
NotClearable {
    private final ClusteredStore store;
    private final SerializationStrategy3<AbstractElementData> serializationStrategy;
    private volatile transient ClassLoader threadContextAwareClassLoader;
    private final boolean copyOnRead;

    ValueModeHandlerSerialization(ClusteredStore store, boolean copyOnRead, boolean compress) {
        this(store, copyOnRead, (SerializationStrategy3<AbstractElementData>)new ElementSerializationStrategy(compress));
    }

    ValueModeHandlerSerialization(ClusteredStore store, boolean copyOnRead, SerializationStrategy3<AbstractElementData> serializationStrategy) {
        this.store = store;
        this.copyOnRead = copyOnRead;
        this.serializationStrategy = serializationStrategy;
        this.init();
    }

    private void init() {
        this.threadContextAwareClassLoader = new ThreadContextAwareClassLoader(ValueModeHandlerSerialization.class.getClassLoader());
        this.loadReferences();
    }

    @Override
    public void loadReferences() {
        this.serializationStrategy.getClass();
    }

    @Override
    public Object createPortableKey(Object key) {
        return this.generateStringKeyFor(key);
    }

    @Override
    public TimestampedValue createTimestampedValue(Element element) {
        byte[] data;
        SerializationModeElementData value = new SerializationModeElementData(element);
        int createTime = TimeUtil.toSecs((long)element.getElementEvictionData().getCreationTime());
        try {
            data = this.serializationStrategy.serialize((Object)value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        value = this.copyOnRead ? null : value;
        SerializedEntryParameters params = new SerializedEntryParameters();
        params.deserialized((Object)value).createTime(createTime).lastAccessedTime(createTime).serialized(data);
        if (element.usesCacheDefaultLifespan()) {
            return new SerializedEntry(params);
        }
        int tti = element.getTimeToIdle();
        int ttl = element.getTimeToLive();
        return new CustomLifespanSerializedEntry(params, tti, ttl);
    }

    @Override
    public void processStoredValue(TimestampedValue value) {
        if (!this.copyOnRead) {
            SerializedEntry serializedEntry = (SerializedEntry)value;
            try {
                serializedEntry.nullByteArray();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public Element createElement(Object key, TimestampedValue value) {
        AbstractElementData data;
        if (null == value) {
            return null;
        }
        SerializedEntry entry = (SerializedEntry)value;
        try {
            data = this.copyOnRead ? (AbstractElementData)((Object)entry.getDeserializedValueCopy(this.serializationStrategy, this.threadContextAwareClassLoader)) : (AbstractElementData)((Object)entry.getDeserializedValue(this.serializationStrategy, this.threadContextAwareClassLoader));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        boolean recalculateSize = entry.shouldRecalculateSize();
        if (recalculateSize) {
            this.store.getBackend().recalculateLocalCacheSize(key);
        }
        Element element = data.createElement(key);
        element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this.store, value));
        return element;
    }

    private String generateStringKeyFor(Object obj) {
        try {
            return this.serializationStrategy.generateStringKeyFor(obj);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object getRealKeyObject(Object portableKey) {
        return this.realKeyObjectFor(portableKey, false);
    }

    @Override
    public Object localGetRealKeyObject(Object portableKey) {
        return this.realKeyObjectFor(portableKey, true);
    }

    private Object realKeyObjectFor(Object portableKey, boolean local) {
        try {
            if (local) {
                return this.serializationStrategy.localDeserializeStringKey((String)portableKey, this.threadContextAwareClassLoader);
            }
            return this.serializationStrategy.deserializeStringKey((String)portableKey, this.threadContextAwareClassLoader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

