/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.modules.ehcache.store.ValueModeHandlerHibernate;
import org.terracotta.modules.ehcache.store.ValueModeHandlerIdentity;
import org.terracotta.modules.ehcache.store.ValueModeHandlerSerialization;

public abstract class ValueModeHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)ValueModeHandlerFactory.class.getName());

    public static ValueModeHandler createValueModeHandler(ClusteredStore store, CacheConfiguration cacheConfiguration) {
        TerracottaConfiguration terracottaConfiguration = cacheConfiguration.getTerracottaConfiguration();
        switch (terracottaConfiguration.getValueMode()) {
            case IDENTITY: {
                return new ValueModeHandlerIdentity(store);
            }
            case SERIALIZATION: {
                if (ValueModeHandlerFactory.hibernateTypesPresent()) {
                    LOG.info("Hibernate types found on the classpath : Enabling Hibernate value mode optimizations");
                    return new ValueModeHandlerHibernate(store, cacheConfiguration.isCopyOnRead(), terracottaConfiguration.isCompressionEnabled());
                }
                return new ValueModeHandlerSerialization(store, cacheConfiguration.isCopyOnRead(), terracottaConfiguration.isCompressionEnabled());
            }
        }
        throw new CacheException("The Terracotta value type '" + terracottaConfiguration.getValueMode() + "' is not supported.");
    }

    private static boolean hibernateTypesPresent() {
        try {
            Class.forName("org.hibernate.cache.CacheKey");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

