/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.terracotta.modules.ehcache.store.AggregateIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableMultiCollectionWrapper<T>
extends AbstractList<T> {
    private final Collection<Collection<? extends T>> delegates;

    public UnmodifiableMultiCollectionWrapper(Collection<? extends T> ... delegates) {
        this.delegates = Collections.unmodifiableList(Arrays.asList(delegates));
    }

    @Override
    public boolean contains(Object obj) {
        for (Collection<T> c : this.delegates) {
            if (!c.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Collection<T> c : this.delegates) {
            if (!c.containsAll(coll)) continue;
            return true;
        }
        for (Collection<Object> o : coll) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int position) {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }

    @Override
    public int indexOf(Object obj) {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> c : this.delegates) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList iterators = new ArrayList(this.delegates.size());
        for (Collection<T> c : this.delegates) {
            iterators.add(c.iterator());
        }
        return new AggregateIterator(iterators);
    }

    @Override
    public int lastIndexOf(Object paramObject) {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }

    @Override
    public ListIterator<T> listIterator(int paramInt) {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }

    @Override
    public int size() {
        long totalSize = 0L;
        for (Collection<T> c : this.delegates) {
            totalSize += (long)c.size();
        }
        if (totalSize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)totalSize;
    }

    @Override
    public List<T> subList(int paramInt1, int paramInt2) {
        throw new UnsupportedOperationException("Delegates to set, operation not supported");
    }
}

