/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.util.ProductInfo;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.api.Terracotta;
import org.terracotta.async.AsyncConfig;
import org.terracotta.async.AsyncCoordinator;
import org.terracotta.cache.serialization.DsoSerializationStrategy;
import org.terracotta.cluster.ClusterInfo;
import org.terracotta.cluster.ClusterLogger;
import org.terracotta.cluster.TerracottaClusterInfo;
import org.terracotta.cluster.TerracottaLogger;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.locking.LockStrategy;
import org.terracotta.locking.LockType;
import org.terracotta.locking.strategy.HashcodeLockStrategy;
import org.terracotta.modules.ehcache.LocalVMResources;
import org.terracotta.modules.ehcache.coherence.CacheShutdownHook;
import org.terracotta.modules.ehcache.event.ClusteredEventReplicator;
import org.terracotta.modules.ehcache.event.TerracottaTopologyImpl;
import org.terracotta.modules.ehcache.store.ClusteredSafeStore;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.operatorevent.ClusterRejoinOperatorEventListener;
import org.terracotta.modules.ehcache.transaction.ClusteredTransactionIDFactory;
import org.terracotta.modules.ehcache.transaction.ReadCommittedClusteredSoftLockFactory;
import org.terracotta.modules.ehcache.writebehind.AsyncWriteBehind;
import org.terracotta.modules.ehcache.writebehind.WriteBehindAsyncConfig;
import org.terracotta.util.TerracottaAtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaClusteredInstanceFactory
implements ClusteredInstanceFactory {
    private static final ClusterLogger LOGGER = new TerracottaLogger(TerracottaClusteredInstanceFactory.class.getName());
    private static final String DELIM = "|";
    public static final String DEFAULT_CACHE_MANAGER_NAME = "__DEFAULT__";
    private static final String ROOT_NAME_STORE = "ehcache-store";
    private static final String ROOT_NAME_EVENT_REPLICATOR = "ehcache-event-replicator";
    private static final String ROOT_NAME_EHCACHE_ASYNC_COORDINATOR = "ehcache-async-coordinator";
    private static final String ROOT_NAME_UTILITIES = "ehcache-utilities";
    private static final String ROOT_NAME_SOFT_LOCK_FACTORIES = "ehcache-softlock-factories";
    private static final String ROOT_NAME_IDS = "ehcache-ids";
    private final Set<CacheStorePair> cacheStorePairs = new HashSet<CacheStorePair>();
    private final Set<String> registeredCacheManagers = new HashSet<String>();

    public TerracottaClusteredInstanceFactory(TerracottaClientConfiguration tcConfig) {
        this.logEhcacheBuildInfo();
        CacheShutdownHook.INSTANCE.init();
    }

    private void logEhcacheBuildInfo() {
        ProductInfo ehcacheCoreProductInfo = new ProductInfo();
        TerracottaLogger logger = new TerracottaLogger(TerracottaClusteredInstanceFactory.class.getName());
        logger.info((Object)ehcacheCoreProductInfo.toString());
        this.assertCoreVersionMatches();
    }

    private void assertCoreVersionMatches() {
        boolean ignoreVersionCheck = Boolean.getBoolean("terracotta.ehcache.versioncheck.skip");
        if (!ignoreVersionCheck) {
            try {
                ProductInfo productInfo;
                InputStream in = null;
                try {
                    in = this.getClass().getClassLoader().getResource("org/terracotta/modules/tim-ehcache-version.properties").openStream();
                    productInfo = new ProductInfo(in);
                }
                catch (IOException ioe) {
                    throw new CacheException("Cannot load product info. Please report this error and try disabling version checking in the meantime by adding -Dterracotta.ehcache.versioncheck.skip=true on the command line.", (Throwable)ioe);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {}
                }
                productInfo.assertRequiredCoreVersionPresent();
            }
            catch (NoSuchMethodError error) {
                throw new CacheException("The version of ehcache-core found on the classpath is too ancient for this version of tim-ehcache. Please make sure you are using a compatible version!");
            }
        }
    }

    public Store createStore(Ehcache cache) {
        ClusteredSafeStore store = this.getOrCreateStore(cache);
        this.connectConfigurations(cache, store);
        return store;
    }

    private static String getCacheManagerName(CacheManager cacheManager) {
        String cacheMgrName = cacheManager.getName();
        if (!cacheManager.isNamed()) {
            cacheMgrName = DEFAULT_CACHE_MANAGER_NAME;
        }
        if (cacheMgrName.endsWith(DELIM)) {
            throw new CacheException("Cache manager name must not end with \"|\" when terracotta clustered");
        }
        return cacheMgrName;
    }

    public WriteBehind createWriteBehind(Ehcache cache) {
        CacheWriterConfiguration config = cache.getCacheConfiguration().getCacheWriterConfiguration();
        WriteBehindAsyncConfig asyncConfig = new WriteBehindAsyncConfig(config.getMinWriteDelay() * 1000, config.getMaxWriteDelay() * 1000, config.getWriteBatching(), config.getWriteBatchSize(), cache.getCacheConfiguration().getTerracottaConfiguration().isSynchronousWrites(), config.getRetryAttempts(), config.getRetryAttemptDelaySeconds() * 1000, config.getRateLimitPerSecond(), config.getWriteBehindMaxQueueSize());
        AsyncCoordinator asyncCoordinator = TerracottaClusteredInstanceFactory.getOrCreateAsyncCoordinator(cache, (AsyncConfig)asyncConfig);
        return new AsyncWriteBehind(asyncCoordinator, cache, TerracottaClusteredInstanceFactory.getSingletonDsoSerializationStrategy());
    }

    public CacheEventListener createEventReplicator(final Ehcache cache) {
        AtomicReference created;
        ClusteredEventReplicator root;
        boolean initializeTransients;
        String cacheMgrName = TerracottaClusteredInstanceFactory.getCacheManagerName(cache.getCacheManager());
        String cacheName = cache.getName();
        final String rootName = "ehcache-event-replicator|" + cacheMgrName + DELIM + cacheName;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Looking up root: " + rootName));
        }
        boolean bl = initializeTransients = (root = (ClusteredEventReplicator)Terracotta.lookupOrCreateRoot((String)rootName, (Callable)new Callable<ClusteredEventReplicator>(created = new AtomicReference()){
            final /* synthetic */ AtomicReference val$created;
            {
                this.val$created = atomicReference;
            }

            @Override
            public ClusteredEventReplicator call() throws Exception {
                ClusteredEventReplicator eventReplicator = TerracottaClusteredInstanceFactory.this.newEventReplicator(cache);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Instantiating new root (" + rootName + ") " + System.identityHashCode(eventReplicator)));
                }
                this.val$created.set(eventReplicator);
                return eventReplicator;
            }
        })) != created.get();
        if (initializeTransients) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Initializing transients for (" + rootName + ") " + System.identityHashCode(root)));
            }
            root.initializeTransients(cache);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Returning root (" + rootName + ") " + System.identityHashCode(root) + " with oid " + TerracottaClusteredInstanceFactory.getOidFor(root)));
        }
        return root;
    }

    private static String getOidFor(Object obj) {
        try {
            Object tco = obj.getClass().getMethod("__tc_managed", new Class[0]).invoke(obj, new Object[0]);
            return tco.getClass().getMethod("getObjectID", new Class[0]).invoke(tco, new Object[0]).toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private ClusteredEventReplicator newEventReplicator(Ehcache cache) {
        return new ClusteredEventReplicator(cache, cache.getCacheConfiguration().getTerracottaConfiguration());
    }

    static ClusteredStore getExistingStore(String cacheMgrName, String cacheName) {
        return (ClusteredStore)Terracotta.lookupOrCreateRoot((String)TerracottaClusteredInstanceFactory.storeRootName(cacheMgrName, cacheName), (Callable)new Callable<ClusteredStore>(){

            @Override
            public ClusteredStore call() throws Exception {
                return null;
            }
        });
    }

    private static String storeRootName(String cacheMgrName, String cacheName) {
        return "ehcache-store|" + cacheMgrName + DELIM + cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredSafeStore getOrCreateStore(Ehcache cache) {
        String cacheMgrName = TerracottaClusteredInstanceFactory.getCacheManagerName(cache.getCacheManager());
        String cacheName = cache.getName();
        if (this.isDCV2(cache)) {
            String string = cacheName.intern();
            synchronized (string) {
                return this.getOrCreateStoreInternal(cacheMgrName, cacheName, cache);
            }
        }
        return this.getOrCreateStoreInternal(cacheMgrName, cacheName, cache);
    }

    private ClusteredSafeStore getOrCreateStoreInternal(String cacheMgrName, String cacheName, final Ehcache cache) {
        boolean initializeTransients;
        this.registerLocalResourceCacheManager(cache.getCacheManager());
        this.registerLocalResourceCache(cache);
        final AtomicReference created = new AtomicReference();
        ClusteredStore root = (ClusteredStore)Terracotta.lookupOrCreateRoot((String)TerracottaClusteredInstanceFactory.storeRootName(cacheMgrName, cacheName), (Callable)new Callable<ClusteredStore>(){

            @Override
            public ClusteredStore call() throws Exception {
                ClusteredStore store = TerracottaClusteredInstanceFactory.this.newStore(cache, TerracottaClusteredInstanceFactory.this.nextID());
                created.set(store);
                return store;
            }
        });
        boolean bl = initializeTransients = root != created.get();
        if (initializeTransients) {
            root.initalizeTransients(cache);
        } else {
            this.waitUntilStoreCreatedInServer(cache);
        }
        this.unregisterLocalResourceCache(cache);
        return new ClusteredSafeStore(root);
    }

    private void unregisterLocalResourceCache(Ehcache cache) {
        LocalVMResources.getInstance().unregisterCache(cache);
    }

    private void registerLocalResourceCache(Ehcache cache) {
        Object oldCache = LocalVMResources.getInstance().registerCache(cache);
        if (oldCache != null && oldCache != cache) {
            throw new CacheException("Some other object mapped for cache with name '" + cache.getName() + "', other: " + oldCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalResourceCacheManager(CacheManager cacheManager) {
        String uuid = this.getCacheManagerClusterId(cacheManager);
        Object object = LocalVMResources.getInstance().registerCacheManager(uuid, cacheManager);
        if (object != null && object != cacheManager) {
            throw new CacheException("Some other object already mapped to current CacheManager's uuid: " + uuid + " object: " + object + ". Probably there are multiple cacheManagers having the same name (or not named at all). " + "Please fix to have unique names for each CacheManager by specifying it in the config");
        }
        Set<String> set = this.registeredCacheManagers;
        synchronized (set) {
            this.registeredCacheManagers.add(uuid);
        }
    }

    private long nextID() {
        TerracottaAtomicLong root = (TerracottaAtomicLong)Terracotta.lookupOrCreateRoot((String)ROOT_NAME_IDS, (Callable)new Callable<TerracottaAtomicLong>(){

            @Override
            public TerracottaAtomicLong call() {
                return new TerracottaAtomicLong();
            }
        });
        return root.getAndIncrement();
    }

    private void waitUntilStoreCreatedInServer(Ehcache ehcache) {
        if (this.isDCV2(ehcache)) {
            Terracotta.waitForAllCurrentTransactionsToComplete();
        }
    }

    private boolean isDCV2(Ehcache ehcache) {
        return TerracottaConfiguration.StorageStrategy.DCV2.equals((Object)ehcache.getCacheConfiguration().getTerracottaConfiguration().getStorageStrategy());
    }

    protected ClusteredStore newStore(Ehcache cache, long uniqueID) {
        return new ClusteredStore(cache, uniqueID);
    }

    private String getCacheManagerClusterId(CacheManager cacheManager) {
        return cacheManager.isNamed() ? cacheManager.getName() : DEFAULT_CACHE_MANAGER_NAME;
    }

    private static AsyncCoordinator getOrCreateAsyncCoordinator(Ehcache cache, final AsyncConfig config) {
        String cacheMgrName = TerracottaClusteredInstanceFactory.getCacheManagerName(cache.getCacheManager());
        String cacheName = cache.getName();
        return (AsyncCoordinator)Terracotta.lookupOrCreateRoot((String)("ehcache-async-coordinator|" + cacheMgrName + DELIM + cacheName), (Callable)new Callable<AsyncCoordinator>(){

            @Override
            public AsyncCoordinator call() throws Exception {
                return new AsyncCoordinator(config);
            }
        });
    }

    private static DsoSerializationStrategy getSingletonDsoSerializationStrategy() {
        ConcurrentMap root = (ConcurrentMap)Terracotta.lookupOrCreateRoot((String)ROOT_NAME_UTILITIES, (Callable)new Callable<ConcurrentMap<String, Object>>(){

            @Override
            public ConcurrentMap<String, Object> call() throws Exception {
                return new ConcurrentDistributedMap(LockType.WRITE, (LockStrategy)new HashcodeLockStrategy(), 8);
            }
        });
        root.putIfAbsent(DsoSerializationStrategy.class.getName(), new DsoSerializationStrategy());
        Terracotta.disableEviction((Object)root);
        return (DsoSerializationStrategy)root.get(DsoSerializationStrategy.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectConfigurations(Ehcache cache, ClusteredSafeStore store) {
        cache.getCacheConfiguration().addConfigurationListener((CacheConfigurationListener)store);
        Set<CacheStorePair> set = this.cacheStorePairs;
        synchronized (set) {
            this.cacheStorePairs.add(new CacheStorePair(cache, store));
        }
        cache.getCacheConfiguration().internalSetDiskCapacity(store.getBackend().getConfig().getTargetMaxTotalCount());
        cache.getCacheConfiguration().internalSetMemCapacity(store.getBackend().getConfig().getTargetMaxInMemoryCount());
        cache.getCacheConfiguration().internalSetTimeToIdle((long)store.getBackend().getConfig().getMaxTTISeconds());
        cache.getCacheConfiguration().internalSetTimeToLive((long)store.getBackend().getConfig().getMaxTTLSeconds());
        cache.getCacheConfiguration().internalSetLogging(store.getBackend().getConfig().isLoggingEnabled());
    }

    public CacheCluster getTopology() {
        return TopologyHolder.TOPOLOGY;
    }

    public String getUUID() {
        return new TerracottaClusterInfo().getUniversallyUniqueClientID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Set<Object> set = this.cacheStorePairs;
        synchronized (set) {
            for (CacheStorePair cacheStorePair : this.cacheStorePairs) {
                cacheStorePair.getCache().getCacheConfiguration().removeConfigurationListener((CacheConfigurationListener)cacheStorePair.getStore());
            }
            this.cacheStorePairs.clear();
        }
        set = this.registeredCacheManagers;
        synchronized (set) {
            for (String uuid : this.registeredCacheManagers) {
                LocalVMResources.getInstance().unregisterCacheManager(uuid);
            }
            this.registeredCacheManagers.clear();
        }
    }

    public TransactionIDFactory createTransactionIDFactory(String uuid) {
        return new ClusteredTransactionIDFactory(uuid);
    }

    public SoftLockFactory getOrCreateSoftLockFactory(Ehcache cache) {
        SoftLockFactory old;
        String cacheName = cache.getName();
        String cacheManagerName = cache.getCacheManager().getName();
        ConcurrentMap<String, SoftLockFactory> factories = TerracottaClusteredInstanceFactory.getSoftLockFactoriesRoot();
        SoftLockFactory softLockFactory = (SoftLockFactory)factories.get(cacheName);
        if (softLockFactory == null && (old = factories.putIfAbsent(cacheName, softLockFactory = new ReadCommittedClusteredSoftLockFactory(cacheManagerName, cacheName))) != null) {
            softLockFactory = old;
        }
        return softLockFactory;
    }

    private static ConcurrentMap<String, SoftLockFactory> getSoftLockFactoriesRoot() {
        ConcurrentMap root = (ConcurrentMap)Terracotta.lookupOrCreateRoot((String)ROOT_NAME_SOFT_LOCK_FACTORIES, (Callable)new Callable<ConcurrentMap<String, SoftLockFactory>>(){

            @Override
            public ConcurrentMap<String, SoftLockFactory> call() throws Exception {
                return new ConcurrentDistributedMap();
            }
        });
        Terracotta.disableEviction((Object)root);
        return root;
    }

    private static class CacheStorePair {
        private final Ehcache cache;
        private final ClusteredSafeStore store;

        private CacheStorePair(Ehcache cache, ClusteredSafeStore store) {
            this.cache = cache;
            this.store = store;
        }

        public Ehcache getCache() {
            return this.cache;
        }

        public ClusteredSafeStore getStore() {
            return this.store;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CacheStorePair)) {
                return false;
            }
            CacheStorePair otherPair = (CacheStorePair)obj;
            return this.cache.getName().equals(otherPair.cache.getName());
        }

        public int hashCode() {
            return this.cache.getName().hashCode();
        }
    }

    private static class TopologyHolder {
        private static final TerracottaTopologyImpl TOPOLOGY;

        private TopologyHolder() {
        }

        static {
            TerracottaClusterInfo clusterInfo = new TerracottaClusterInfo();
            TOPOLOGY = new TerracottaTopologyImpl((ClusterInfo)clusterInfo);
            try {
                TOPOLOGY.addTopologyListener(new ClusterRejoinOperatorEventListener(clusterInfo.waitUntilNodeJoinsCluster()));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to register: " + ClusterRejoinOperatorEventListener.class.getName()), (Throwable)e);
            }
        }
    }
}

