/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.DefaultSizeOfEngine;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cluster.TerracottaProperties;
import org.terracotta.locking.LockType;
import org.terracotta.locking.TerracottaLock;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.ValueModeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBufferedMap<K, V> {
    private static final int MAX_SIZEOF_DEPTH = 1000;
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_BATCH_BYTE_SIZE = 0x500000;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_BATCH_TIME_MILLIS = 600;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_THROTTLE_BYTE_SIZE = 0xA00000;
    private static final String CONCURRENT_TXN_LOCK_ID = "local-buffer-static-concurrent-txn-lock-id";
    private static final int PUTS_BATCH_BYTE_SIZE = LocalBufferedMap.getTerracottaProperty("ehcache.incoherent.putsBatchByteSize", 0x500000);
    private static final long BATCH_TIME_MILLISECS = LocalBufferedMap.getTerracottaProperty("ehcache.incoherent.putsBatchTimeInMillis", 600);
    private static final long THROTTLE_PUTS_BYTE_SIZE = LocalBufferedMap.getTerracottaProperty("ehcache.incoherent.throttlePutByteSize", 0xA00000);
    private static final Map EMPTY_MAP = Collections.EMPTY_MAP;
    private static final int LOCAL_MAP_INITIAL_CAPACITY = 128;
    private static final float LOCAL_MAP_LOAD_FACTOR = 0.75f;
    private static final int LOCAL_MAP_INITIAL_SEGMENTS = 128;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_BATCH_SIZE = 600;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_THROTTLE_SIZE = 200000;
    private static final int PUTS_BATCH_SIZE = LocalBufferedMap.getTerracottaProperty("ehcache.incoherent.putsBatchSize", 600);
    private static final long THROTTLE_PUTS_SIZE = LocalBufferedMap.getTerracottaProperty("ehcache.incoherent.throttlePutsAtSize", 200000);
    private final FlushToServerThread flushToServerThread;
    private final ClusteredStoreBackend<Object, Object> clusteredStoreBackend;
    private final CacheCoherence incoherentNodesSet;
    private final ValueModeHandler valueModeHandler;
    private volatile Map<K, ValueWithMetaData<V>> collectBuffer;
    private volatile Map<K, ValueWithMetaData<V>> flushBuffer;
    private volatile boolean clearMap = false;
    private volatile AtomicLong pendingOpsSize = new AtomicLong();
    private final SizeOfEngine sizeOfEngine;
    private volatile MetaData clearMetaData;

    private static int getTerracottaProperty(String propName, int defaultValue) {
        try {
            return new TerracottaProperties().getInteger(propName, Integer.valueOf(defaultValue));
        }
        catch (UnsupportedOperationException e) {
            return defaultValue;
        }
    }

    public LocalBufferedMap(ClusteredStoreBackend<Object, Object> clusteredStoreBackend, CacheCoherence incoherentNodesSet, ValueModeHandler valueModeHandler) {
        this.clusteredStoreBackend = clusteredStoreBackend;
        this.valueModeHandler = valueModeHandler;
        this.collectBuffer = this.newMap();
        this.flushBuffer = EMPTY_MAP;
        this.incoherentNodesSet = incoherentNodesSet;
        this.flushToServerThread = new FlushToServerThread("Incoherent LocalBufferredMap Flush Thread [" + clusteredStoreBackend.getConfig().getName() + "]", this);
        this.flushToServerThread.setDaemon(true);
        this.sizeOfEngine = new DefaultSizeOfEngine(1000, true);
    }

    private Map<K, ValueWithMetaData<V>> newMap() {
        return new ConcurrentHashMap(128, 0.75f, 128);
    }

    public V get(K key) {
        ValueWithMetaData<V> v = this.collectBuffer.get(key);
        if (v != null && v.isRemove()) {
            return null;
        }
        if (v != null) {
            return v.getValue();
        }
        v = this.flushBuffer.get(key);
        if (v != null && v.isRemove()) {
            return null;
        }
        return v == null ? null : (V)v.getValue();
    }

    public V remove(K key, MetaData metaData) {
        RemoveValueWithMetaData removeVWMD = new RemoveValueWithMetaData(metaData);
        ValueWithMetaData old = this.collectBuffer.put(key, removeVWMD);
        if (old == null) {
            this.pendingOpsSize.addAndGet(this.sizeOfEngine.sizeOf(key, removeVWMD, null).getCalculated());
            return null;
        }
        return old.isRemove() ? null : (V)old.getValue();
    }

    public boolean containsKey(K key) {
        ValueWithMetaData<V> v = this.collectBuffer.get(key);
        if (v != null) {
            return !v.isRemove();
        }
        v = this.flushBuffer.get(key);
        return v != null && !v.isRemove();
    }

    public int getSize() {
        int size = 0;
        Map<K, ValueWithMetaData<V>> localCollectingMap = this.collectBuffer;
        Map<K, ValueWithMetaData<V>> localFlushMap = this.flushBuffer;
        for (Map.Entry<K, ValueWithMetaData<Object>> e : localCollectingMap.entrySet()) {
            if (e.getValue() == null || e.getValue().isRemove()) continue;
            ++size;
        }
        for (Map.Entry<K, ValueWithMetaData<Object>> e : localFlushMap.entrySet()) {
            if (e.getValue() == null || e.getValue().isRemove()) continue;
            ++size;
        }
        return size;
    }

    public void clear(MetaData metaData) {
        this.collectBuffer.clear();
        this.flushBuffer.clear();
        this.clearMap = true;
        this.clearMetaData = metaData;
        this.pendingOpsSize.set(0L);
    }

    public Collection getKeys() {
        HashSet<K> keySet = new HashSet<K>(this.collectBuffer.keySet());
        keySet.addAll(this.flushBuffer.keySet());
        return keySet;
    }

    public void put(K key, V value, MetaData metaData) {
        ValueWithMetaData<V> valueWMD = new ValueWithMetaData<V>(value, metaData);
        if (this.collectBuffer.put(key, valueWMD) == null) {
            this.throttleIfNecessary(this.pendingOpsSize.addAndGet(this.sizeOfEngine.sizeOf(key, valueWMD, null).getCalculated()));
        }
    }

    void startThreadIfNecessary() {
        this.flushToServerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throttleIfNecessary(long currentPendingSize) {
        if (currentPendingSize <= THROTTLE_PUTS_BYTE_SIZE) {
            return;
        }
        this.incoherentNodesSet.releaseReadLock();
        try {
            while (currentPendingSize > THROTTLE_PUTS_BYTE_SIZE) {
                this.sleepMillis(100L);
                currentPendingSize = this.pendingOpsSize.get();
            }
        }
        finally {
            this.incoherentNodesSet.acquireReadLock();
        }
    }

    private void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    ValueWithMetaData<V> internalGetFromCollectingMap(K key) {
        return this.collectBuffer.get(key);
    }

    void internalPutInFlushBuffer(K key, V value, MetaData metaData) {
        this.flushBuffer.put(key, new ValueWithMetaData<V>(value, metaData));
    }

    void allowFlushBufferWrites() {
        if (this.flushBuffer == EMPTY_MAP) {
            this.flushBuffer = this.newMap();
        }
    }

    public void dispose() {
        this.flushAndStopBuffering();
        this.flushToServerThread.markFinish();
    }

    public void shutdown() {
        this.flushToServerThread.markFinish();
    }

    public void startBuffering() {
        if (this.flushToServerThread.isFinished()) {
            throw new AssertionError((Object)"Start Buffering called when flush thread has already finished");
        }
        this.flushToServerThread.unpause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndStopBuffering() {
        this.flushToServerThread.waitUntilFlushCompleteAndPause();
        this.switchBuffers(this.newMap());
        try {
            this.drainBufferToServer(this.flushBuffer);
        }
        finally {
            this.flushBuffer = EMPTY_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPeriodicFlush(FlushToServerThread thread) {
        Map<K, ValueWithMetaData<V>> localMap = this.newMap();
        this.incoherentNodesSet.acquireWriteLock();
        try {
            if (!thread.markFlushInProgress()) {
                return;
            }
            this.switchBuffers(localMap);
        }
        finally {
            this.incoherentNodesSet.releaseWriteLock();
        }
        try {
            this.drainBufferToServer(this.flushBuffer);
        }
        finally {
            this.flushBuffer = EMPTY_MAP;
            thread.markFlushComplete();
        }
    }

    private void switchBuffers(Map<K, ValueWithMetaData<V>> newBuffer) {
        this.flushBuffer = this.collectBuffer;
        this.collectBuffer = newBuffer;
        this.pendingOpsSize.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainBufferToServer(Map<K, ValueWithMetaData<V>> buffer) {
        this.clearIfNecessary();
        Set<Map.Entry<K, ValueWithMetaData<V>>> entrySet = buffer.entrySet();
        if (entrySet.isEmpty()) {
            return;
        }
        Lock lock = this.getConcurrentTransactionLock();
        lock.lock();
        try {
            for (Map.Entry<K, ValueWithMetaData<V>> entry : entrySet) {
                ValueWithMetaData<V> value = entry.getValue();
                K key = entry.getKey();
                if (value.isRemove()) {
                    this.clusteredStoreBackend.unlockedRemoveNoReturn(key, value.getMetaData());
                    continue;
                }
                this.clusteredStoreBackend.unlockedPutNoReturn(key, value.getValue(), value.getMetaData());
            }
            lock.unlock();
        }
        catch (Throwable throwable) {
            lock.unlock();
            for (ValueWithMetaData<V> value : buffer.values()) {
                V v = value.getValue();
                if (!(v instanceof TimestampedValue)) continue;
                this.valueModeHandler.processStoredValue((TimestampedValue)v);
            }
            throw throwable;
        }
        for (ValueWithMetaData valueWithMetaData : buffer.values()) {
            Object v = valueWithMetaData.getValue();
            if (!(v instanceof TimestampedValue)) continue;
            this.valueModeHandler.processStoredValue((TimestampedValue)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIfNecessary() {
        if (this.clearMap) {
            Lock lock = this.getConcurrentTransactionLock();
            lock.lock();
            try {
                this.clusteredStoreBackend.clear(this.clearMetaData);
            }
            finally {
                lock.unlock();
                this.clearMap = false;
                this.clearMetaData = null;
            }
        }
    }

    protected Lock getConcurrentTransactionLock() {
        return new TerracottaLock((Object)CONCURRENT_TXN_LOCK_ID, LockType.CONCURRENT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RemoveValueWithMetaData<T>
    extends ValueWithMetaData<T> {
        RemoveValueWithMetaData(MetaData metaData) {
            super(null, metaData);
        }

        @Override
        boolean isRemove() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueWithMetaData<T> {
        private final MetaData metaData;
        private final T value;

        ValueWithMetaData(T value, MetaData metaData) {
            this.value = value;
            this.metaData = metaData;
        }

        MetaData getMetaData() {
            return this.metaData;
        }

        T getValue() {
            return this.value;
        }

        boolean isRemove() {
            return false;
        }
    }

    private static class FlushToServerThread
    extends Thread {
        private final LocalBufferedMap localBufferedMap;
        private State state = State.NOT_STARTED;

        public FlushToServerThread(String name, LocalBufferedMap localBufferedMap) {
            super(name);
            this.localBufferedMap = localBufferedMap;
        }

        public void unpause() {
            this.moveTo(State.PAUSED, State.SLEEP);
        }

        public void run() {
            while (!this.isFinished()) {
                this.waitUntilNotPaused();
                if (this.localBufferedMap.pendingOpsSize.get() < (long)PUTS_BATCH_BYTE_SIZE) {
                    this.sleepFor(BATCH_TIME_MILLISECS);
                }
                this.localBufferedMap.doPeriodicFlush(this);
            }
        }

        private void waitUntilNotPaused() {
            this.waitUntilNotIn(State.PAUSED);
        }

        private synchronized boolean isFinished() {
            return this.state == State.FINISHED;
        }

        public void markFinish() {
            this.moveTo(State.FINISHED);
        }

        public boolean markFlushInProgress() {
            return this.moveTo(State.SLEEP, State.FLUSH);
        }

        public boolean markFlushComplete() {
            return this.moveTo(State.FLUSH, State.SLEEP);
        }

        public synchronized void waitUntilFlushCompleteAndPause() {
            this.waitUntilNotIn(State.FLUSH);
            this.moveTo(State.SLEEP, State.PAUSED);
        }

        public synchronized void start() {
            if (this.moveTo(State.NOT_STARTED, State.PAUSED)) {
                super.start();
            }
        }

        private void sleepFor(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private synchronized void waitUntilNotIn(State current) {
            while (this.state == current) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private synchronized void moveTo(State newState) {
            this.state = newState;
            this.notifyAll();
        }

        private synchronized boolean moveTo(State oldState, State newState) {
            if (this.state == oldState) {
                this.state = newState;
                this.notifyAll();
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            NOT_STARTED,
            PAUSED,
            SLEEP,
            FLUSH,
            FINISHED;

        }
    }
}

