/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.hibernate.cache.CacheKey;
import org.hibernate.type.Type;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.locking.LockType;
import org.terracotta.locking.TerracottaLock;
import org.terracotta.modules.ehcache.store.ElementSerializationStrategy;
import org.terracotta.modules.ehcache.store.UnknownHibernateType;

public class HibernateElementSerializationStrategy
extends ElementSerializationStrategy {
    private static final int NON_CACHE_KEY_MAPPING = -1;
    private final ConcurrentDistributedMap<String, Integer> entityRoleMappings = new ConcurrentDistributedMap();

    public HibernateElementSerializationStrategy(boolean compress) {
        super(compress);
    }

    protected void writeStringKey(Object key, ObjectOutputStream oos) throws IOException {
        if (key instanceof CacheKey) {
            CacheKey cacheKey = (CacheKey)key;
            oos.writeInt(this.getOrCreateMapping(cacheKey.getEntityOrRoleName()));
            oos.writeObject(cacheKey.getKey());
        } else {
            oos.writeInt(-1);
            super.writeStringKey(key, oos);
        }
    }

    protected Object readStringKey(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int mapping = ois.readInt();
        if (mapping == -1) {
            return super.readStringKey(ois);
        }
        Serializable innerKey = (Serializable)ois.readObject();
        return new CacheKey(innerKey, (Type)new UnknownHibernateType(), this.getEntityOrRoleName(mapping), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrCreateMapping(String entityOrRoleName) {
        Integer mapping = (Integer)this.entityRoleMappings.unsafeGet((Object)entityOrRoleName);
        if (mapping == null) {
            TerracottaLock lock = new TerracottaLock(this.entityRoleMappings, LockType.WRITE);
            lock.lock();
            try {
                Integer prev;
                mapping = (Integer)this.entityRoleMappings.get((Object)entityOrRoleName);
                if (mapping == null && null != (prev = (Integer)this.entityRoleMappings.put((Object)entityOrRoleName, (Object)(mapping = Integer.valueOf(this.entityRoleMappings.size()))))) {
                    throw new AssertionError((Object)("mapping exists for " + entityOrRoleName + "(" + prev + ")"));
                }
            }
            finally {
                lock.unlock();
            }
        }
        return mapping;
    }

    private String getEntityOrRoleName(int encoding) {
        for (Map.Entry e : this.entityRoleMappings.entrySet()) {
            Integer value = (Integer)e.getValue();
            if (value == null || value != encoding) continue;
            return (String)e.getKey();
        }
        return null;
    }
}

