/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.ehcache.AbstractElementData;
import net.sf.ehcache.SerializationModeElementData;
import org.terracotta.cache.serialization.DsoSerializationStrategy;
import org.terracotta.cache.serialization.DsoSerializationStrategy3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSerializationStrategy
extends DsoSerializationStrategy3<AbstractElementData> {
    private final boolean compress;

    public ElementSerializationStrategy(boolean compress) {
        this.compress = compress;
    }

    public AbstractElementData deserialize(byte[] data) throws IOException, ClassNotFoundException {
        InputStream in = new ByteArrayInputStream(data);
        if (this.compress) {
            in = new GZIPInputStream(in);
        }
        DsoSerializationStrategy.OIS ois = new DsoSerializationStrategy.OIS(in, this.oscSerializer);
        return SerializationModeElementData.create((ObjectInputStream)ois);
    }

    public AbstractElementData deserialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        InputStream in = new ByteArrayInputStream(data);
        if (this.compress) {
            in = new GZIPInputStream(in);
        }
        DsoSerializationStrategy.OIS ois = new DsoSerializationStrategy.OIS(in, this.oscSerializer, loader);
        return SerializationModeElementData.create((ObjectInputStream)ois);
    }

    public byte[] serialize(AbstractElementData element) throws IOException {
        ByteArrayOutputStream baos;
        OutputStream out = baos = new ByteArrayOutputStream();
        if (this.compress) {
            out = new GZIPOutputStream(out);
        }
        DsoSerializationStrategy.OOS oos = new DsoSerializationStrategy.OOS(out, this.oscSerializer);
        element.write((ObjectOutputStream)oos);
        oos.close();
        return baos.toByteArray();
    }
}

